## 项目跟进

- 「🛏 未开始」自定义组件兼容
- 「🛏 未开始」自定义URL
- 「🛏 未开始」UIDL拆分
- 「🛏 未开始」流量朔源
  - [[aPaaS.技术方案\] 流量溯源](https://bytedance.feishu.cn/docx/UkHddQoJFo1eXuxGiZ9cc3m8nqe?chatTab=1&useIframe=1&multiPage=1) 
- 「🛏 未开始」2.0支持第三方鉴权
  - https://meego.feishu.cn/apaas_/story/detail/9244041?parentUrl=%2Fworkbench#comment
  - [[权限\][技术方案]Permission支持三方鉴权](https://bytedance.feishu.cn/wiki/wikcngYd6Z94pmUqepxGTh2E74e) 
  - [【技术方案】「支持三方鉴权」FE](https://bytedance.feishu.cn/wiki/wikcnPndBrwIAIIOgi6McAdcVkf) 
- 「🛏 未开始」支持有引用记录的应用生成安装包链接
  - [【PRD】应用增长 - 支持有引用记录的应用生成安装包链接 - 第 1 次议会评审](https://bytedance.feishu.cn/docx/doxcnxHruxtWqdMSWyPUy5be5Th) 
  - [技术方案 - Builder 支持引用记录的链接安装](https://bytedance.feishu.cn/docx/NdRmdjtbHov8dHxUcZfcbSwQnsh) 
  - [场景梳理 - UI 支持引用记录的链接安装](https://bytedance.feishu.cn/docx/LaKIdxlneo8fPjxEiPpcp9FYnfe) 
  - 依赖项
    - 设计态错误检查
    - 组件属性定位功能
- 「🛏 未开始」前端API ID治理专项
  - [APIID统一生成规则方案](https://bytedance.feishu.cn/docx/Y4fBd8kwFotbJRx7m7VcZiK7nvf?chatTab=1&useIframe=1&multiPage=1) 
  - [Roadmap专项对齐](https://bytedance.feishu.cn/docx/AlavdAlYPoipFkxZKHNccQyunBd?chatTab=1&useIframe=1&multiPage=1) 
  - [前端模块划分及Builder1.0下线时间对齐](https://bytedance.feishu.cn/docx/WTEcdztrNoEnMVxwKHEcQGapnJd) 
  - [aPaaS APIID治理专项Kickoff](https://bytedance.feishu.cn/docx/ZaL6dWtnxoUg1KxlIYQcQrh7nYw) 
  - [URL 规范改造影响范围](https://bytedance.feishu.cn/docx/RPe1d2XXYoiKbmxKDrsc3cWungb) 
  - [ID 、API ID、API Name 现状问题 case 分析](https://bytedance.feishu.cn/docx/Dr6odwWfroJCM2xmxQWcA1SRnzd) 
- 「🛠 进行中」一体化编辑器，实时保存，草稿预览，用户手动提交沙箱态
  - https://meego.feishu.cn/apaas_/story/detail/8478005
  - [一体化编辑器 - 草稿保存、加锁机制（评审通过）](https://bytedance.feishu.cn/wiki/wikcnooAYd9MGwG5Td5SnuTVQNg) 
  - [一体化编辑器「草稿 + 编辑锁」改动汇总](https://bytedance.feishu.cn/docx/ZPBQdz1G2otfOwxSrXgcUQi6nFg) 
  - [UX-aPaaS-一体化编辑器框架导航优化（评审通过）](https://bytedance.feishu.cn/wiki/wikcnYRViGoZBRi7OO3QwVm0eYf) 
  - [「Figma」一体化编辑器UX设计稿](https://www.figma.com/file/x9qsFIizOZfgT0oQqh4uDI/一体化专项?node-id=559%3A269336&t=UXWA4ZoFIgqCj8lC-1)
  - 依赖项：
    - ✅ 页面变量初始化完成回调函数注册
    - ✅ 国际化面板CURD与初始化回调函数注册
    - 发布态页面列表接口（需要过滤掉所有未发布页面）
  - 分支 `feature-aio-editor`：
    - 自动保存服务 `refactor-auto-save-service`
    - 草稿预览功能 `feature-draft-preview`
    - Header还原UI设计稿 `perf-kunlun-header-ui`
    - 统一保存接口 `feature-centralized-update`
- 「🛠 进行中」无代码搭建复合组件
  - https://meego.feishu.cn/apaas_/story/detail/7035300
  - [【Builder 2.0】可重复使用的复合组件 - 宣讲版](https://bytedance.feishu.cn/docx/UNG2dTzfGo6YIuxyAjfc87bnn4f) 
- 「 已完成」低代码融合HTMLComponent，自定义组件引用收集
  - https://meego.feishu.cn/apaas_/story/detail/8516034
  - [低代码融合2期技术方案](https://bytedance.feishu.cn/docx/CsbTdeGtBooBYKxzwf7c85dKnVh) 
- 「 已完成」飞书卡片搭建，支持飞书评论引用收集
  - https://meego.feishu.cn/apaas_/story/detail/7352483?activeStateId=waiting_for_server_development
- 「 已完成」视图表vtable引用收集
  - https://meego.feishu.cn/apaas_/story/detail/7482211
  - [视图表技术方案](https://bytedance.feishu.cn/docx/JFX0d1RyKoT1RBxaYLlcZFxdn4e) 

---

## 2月28日

| 工作事项                     | 进度     | 项目                         | 文档                                                         | 工作量 | 协作者 |
| ---------------------------- | -------- | ---------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 预览面板在自动保存后重新加载 | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [feat: 预览面板在自动保存后重新加载](https://code.byted.org/nclc-platform/kunlun-builder/commit/9aae37ef6bcb2b1b6bd46c32d97ecd2a4c216bb3) | M      |        |
| 预览页header栏适配设计稿     | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [perf: 预览页header栏适配设计稿](https://code.byted.org/nclc-platform/kunlun-builder/commit/413bea3c76e4cc72427358eceb7c17b117b39061) | M      |        |
| 草稿预览身份模拟方案确定     | ✅ 已完成 | Kunlun Builder, 一体化编辑器 |                                                              |        |        |
| 开启草稿预览页身份模拟       | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [chore: 开启草稿预览页身份模拟](https://code.byted.org/nclc-platform/kunlun-builder/commit/0d075f0ab83612d47148931840aef59ac94983d9) | XS     |        |
| 预览面板在自动保存后重新加载 | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [feat: 预览面板在自动保存后重新加载](https://code.byted.org/nclc-platform/kunlun-builder/commit/9aae37ef6bcb2b1b6bd46c32d97ecd2a4c216bb3) | M      |        |
| 预览页header栏适配设计稿     | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [perf: 预览页header栏适配设计稿](https://code.byted.org/nclc-platform/kunlun-builder/commit/413bea3c76e4cc72427358eceb7c17b117b39061) | S      |        |

### 明日计划

- 自动保存性能优化
- 草稿预览插件自动加载性能优化

---

## 2月27日

| 工作事项                             | 进度       | 项目                         | 文档                                                         | 工作量 | 协作者 |
| ------------------------------------ | ---------- | ---------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 草稿预览改为全局弹层                 | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [refactor: 草稿预览改为全局弹层](https://code.byted.org/nclc-platform/kunlun-builder/commit/c5081f0ab7db54104c5fb12e284c524d6d4879a7) | L      |        |
| 页面变量与页面设置弹层形态适配设计稿 | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [refactor: 页面变量与页面设置弹层形态适配设计稿](https://code.byted.org/nclc-platform/kunlun-builder/commit/e288b1baaa9992b2b1966c029f0f888609062794) | M      |        |
| 对齐草稿预览身份模拟功能             | ✅ 已完成   | Kunlun Builder, 一体化编辑器 |                                                              |        | 李立刚 |
| 验证预览页身份模拟                   | ⏱ 推迟一天 | Kunlun Builder, 一体化编辑器 |                                                              |        |        |

### 笔记

- 草稿预览身份模拟功能
  -  上下文：
  -  一体化编辑器后kunlun的预览分为两种
  - 沙箱预览，和原来的预览没有区别
  - 草稿预览，在设计接口态运行，调用设计器的UIDL接口，但是使用沙箱的测试数据
  -  但由于接口权限过滤，仅有最高权限才能调用设计器UIDL接口，这导致身份模拟功能无法在草稿预览时正常启用，除非模拟的是管理员和开发者。
  -  因此现在得出的方案是，要求设计器UIDL接口绕过gateway身份模拟后的权限限制，采用真实身份来来做权限校验。
  -  需求总结：
  -  页面草稿态数据的接口，要求接口请求人必须是应用开发者或者管理员。如果需求是，身份切换后，依然能够请求该接口，需要后端同学出的方案是：
  - 草稿态数据请求接口，不走身份切换的校验逻辑，单独校验是否为管理员或者开发者。 
  -  本次会需要对齐的是：
  - gateway这里针对特点接口做真实身份鉴权的可行性和工作量
  - 能不能在3.6之前完成，如果不能完成，草稿预览接口直接绕过权限检查作为应急方案，会不会有安全风险

### 明日计划

- 草稿预览身份模拟功能会议
- 验证预览页身份模拟功能

---

## 2月24日

| 工作事项                       | 进度       | 项目                         | 文档                                                         | 工作量 | 协作者 |
| ------------------------------ | ---------- | ---------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 联调统一保存接口               | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [Builder2.0页面保存update聚合接口](https://bytedance.feishu.cn/docx/DC4MdgG3Joecsox6PUfcuvVDnOg?chatTab=1&useIframe=1&multiPage=1) | S      |        |
| 对自定义组件引用收集做适配     | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [feat: 对自定义组件引用收集做适配](https://code.byted.org/nclc-platform/kunlun-builder/commit/e766ea850741e58e2cf6ad2a8a6d804e094545eb) | XS     |        |
| 接入统一保存接口               | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [feat: 接入统一保存接口](https://code.byted.org/nclc-platform/kunlun-builder/commit/56239938cb660c30cdab71dc76600fd768eed939) | M      |        |
| 修复i18n重复触发update请求     | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [fix: 修复i18n重复触发update请求](https://code.byted.org/nclc-platform/kunlun-builder/commit/e5fc98b5a8b286f03a5e183d4a8dc8a311243762) | S      |        |
| 修复画布拖入组件会触发两次更新 | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [fix: 修复画布拖入组件会触发两次更新](https://code.byted.org/nclc-platform/kunlun-builder/commit/cecb7f6dcf8b45f1a70169ad4dcfbadb77d2cc7c) | M      |        |
| 修复页面退出前三秒内容丢失     | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [feat: 修复页面退出前三秒内容丢失](https://code.byted.org/nclc-platform/kunlun-builder/commit/152ae417b0bb8b4eb096b9060b5e1d6e5b50e244) | S      |        |
| 弹层插件调整                   | ⏱ 推迟一天 | Kunlun Builder, 一体化编辑器 |                                                              |        |        |

### 明日计划

- 弹层插件调整

---

## 2月23日

| 工作事项                        | 进度       | 项目                         | 文档                                                         | 工作量 | 协作者 |
| ------------------------------- | ---------- | ---------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 联调统一保存接口                | ⏱ 推迟一天 | Kunlun Builder, 一体化编辑器 | [Builder2.0页面保存update聚合接口](https://bytedance.feishu.cn/docx/DC4MdgG3Joecsox6PUfcuvVDnOg?chatTab=1&useIframe=1&multiPage=1) |        |        |
| 预览页预加载功能                | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [feat: 预览页预加载功能](https://code.byted.org/nclc-platform/kunlun-builder/commit/d09cfb468c66dbd0c5996ceceb9318dab3616842) | M      |        |
| 同步设计态与预览态样式          | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [perf: 同步设计态与预览态样式](https://code.byted.org/nclc-platform/kunlun-builder/commit/2817b3a11de02c68149b8ac24c8909a42ea7cae9) | M      |        |
| 自动保存服务注册支持保存回调    | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [feat: 自动保存服务注册支持保存回调](https://code.byted.org/nclc-platform/kunlun-builder/commit/23d0f96e958487538156a7b1bc51ccdfeeee2b93) | M      |        |
| Builder 2.0 自定义组件可使用SDK | ✅ 已完成   | Kunlun Builder, 组件规范     | [Builder 2.0 组件开发文档](https://bytedance.sg.feishu.cn/docx/U0gDdqnPfoWivJxrPXWlFS1RgWb?chatTab=1&useIframe=1&multiPage=1) | S      | Hugo   |
| 调研新版DX SDK能力              | ✅ 已完成   | Kunlun Builder, 组件规范     | [SDK 使用指南](https://bytedance.feishu.cn/wiki/wikcnUbdHnrz2J0GDATnKuIjwSc) | S      | Hugo   |
| LowCode到ProCode基线确认        | ✅ 已完成   | Kunlun Builder, 组件规范     | [LowCode到ProCode基线](https://bytedance.feishu.cn/mindnotes/bmncnRU6mMu3Ef9UiiTjh1C1Dsb#mindmap) | M      | Hugo   |

### 明日计划

- 联调统一保存接口

---

## 2月22日

| 工作事项                       | 进度     | 项目                         | 文档                                                         | 工作量 | 协作者 |
| ------------------------------ | -------- | ---------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 修复保存中样式与icon指针样式   | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [fix: 修复保存中样式与icon指针样式](https://code.byted.org/nclc-platform/kunlun-builder/commit/98960992342ba0532e2d526208420b39d2ac906c) | S      | 项仁明 |
| 修复提交预览按钮样式           | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [fix: 修复提交预览按钮样式](https://code.byted.org/nclc-platform/kunlun-builder/commit/534a2ac9ae16f2a833d7060990b07b6f06cde3ef) | XS     | 项仁明 |
| 修复按钮最小宽度               | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [fix: 修复按钮最小宽度](https://code.byted.org/nclc-platform/kunlun-builder/commit/d2dfce10e8b714b7b849125443f2773e363f0088) | XS     | 项仁明 |
| 预览面板插件增加iFrame弹层功能 | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [feat: 预览面板插件增加iFrame弹层功能](https://code.byted.org/nclc-platform/kunlun-builder/commit/5fb4597d383bfc03b3f84f10790a073a7d7b0129) | L      |        |

### 明日计划

- 联调统一保存接口
- 预览页预加载功能
- 同步设计态与预览态样式

---

## 2月21日

| 工作事项                       | 进度       | 项目                         | 文档                                                         | 工作量 | 协作者 |
| ------------------------------ | ---------- | ---------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 跟进后端接口进度               | ✅ 已完成   | Kunlun Builder, 一体化编辑器 |                                                              | M      |        |
| Header栏还原UI设计稿           | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [feat: Header栏还原UI设计稿](https://code.byted.org/nclc-platform/kunlun-builder/commit/c9495b458a0c84a35f3fcab682e2b87d57b04159) | L      | 项仁明 |
| 微调Header间距适配设计稿       | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [perf: 微调Header间距适配设计稿](https://code.byted.org/nclc-platform/kunlun-builder/commit/64573941181259f6d34c2b9ac63b92f78eda0559) | S      | 项仁明 |
| 设计态草稿预览面板插件基座     | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [feat: 设计态草稿预览面板插件基座](https://code.byted.org/nclc-platform/kunlun-builder/commit/9cee0dac4c419e4f557867b8d2ee75522c06f6c7) | L      |        |
| 预览面板插件增加iFrame弹层功能 | ⏱ 推迟一天 | Kunlun Builder, 一体化编辑器 |                                                              |        |        |

### 笔记

- 后端需求需要建Meego
  - https://meego.feishu.cn/apaas_/story/detail/9468322?parentUrl=%2Fworkbench
  - https://meego.feishu.cn/apaas_/story/detail/9467255?parentUrl=%2Fworkbench

### 明日计划

- 修复保存中样式与icon指针样式
- 预览面板插件增加iFrame弹层功能

---

## 2月20日

| 工作事项                                 | 进度         | 项目                         | 文档                                                         | 工作量 | 协作者 |
| ---------------------------------------- | ------------ | ---------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 收集自定义组件引用                       | ✅ 已完成     | Kunlun Builder, 元数据引用   | [feat: 收集自定义组件引用](https://code.byted.org/nclc-platform/kunlun-builder/commit/0588823d48862618b0fcb2a11de89051db7e7a29) | M      |        |
| 22Q4与23Q1的Meego需求录入                | ✅ 已完成     | UIPaaS                       |                                                              |        |        |
| 验证沙箱数据接口能否在设计态接口环境跑通 | ✅ 已完成     | Kunlun Builder, 一体化编辑器 |                                                              | S      |        |
| 梳理需要草稿预览后端额外提供的接口       | ✅ 已完成     | Kunlun Builder, 一体化编辑器 |                                                              | S      |        |
| 草稿预览功能                             | ✅ 已完成     | Kunlun Builder, 一体化编辑器 | [feat: 草稿预览功能](https://code.byted.org/nclc-platform/kunlun-builder/commit/0e51d4f24f2b0a06c387066171a0e3f44d50f2bd) | M      |        |
| Header栏还原UI设计稿                     | 📈 连续到明天 | Kunlun Builder, 一体化编辑器 |                                                              |        |        |

### 明日计划

- Header栏还原UI设计稿 [Figma 迁移UIPaaS方案](https://www.figma.com/file/tWU53TQKpx12k5fUUHsAaZ/迁移-UI-PaaS-方案?node-id=1338%3A58312)@项仁明 

---

## 2月17日

| 工作事项                                 | 进度         | 项目                         | 文档                                                         | 工作量 | 协作者 |
| ---------------------------------------- | ------------ | ---------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 电商自定义组件梳理                       | ✅ 已完成     | Kunlun Builder, DX兼容       | [电商自定义组件梳理](https://bytedance.feishu.cn/docx/FV7Yd7PKsoyvh8xKjvIc1pknnFc) | XL     |        |
| 重新评估草稿态预览需求合理性             | ✅ 已完成     | Kunlun Builder, 一体化编辑器 | [关于一体化编辑器，builder内的草稿态预览的建议](https://bytedance.feishu.cn/docx/DvINdO7aeowEgpxjmvAcymM4nuc) | S      | 张帅   |
| 自定义组件引用收集                       | 📈 连续到明天 | Kunlun Builder, 元数据引用   |                                                              | M      |        |
| 梳理草稿预览需要后端额外提供的接口       | ⏱ 推迟一天   | Kunlun Builder, 一体化编辑器 |                                                              |        |        |
| 验证沙箱数据接口能否在设计态接口环境跑通 | ⏱ 推迟一天   | Kunlun Builder, 一体化编辑器 |                                                              |        |        |

### 笔记

- 重新评估草稿态预览需求合理性
  -  草稿预览技术方案文档 [一体化编辑器技术文档（Builder部分文档）](https://bytedance.feishu.cn/docx/THQUdsFRioh7K2xuuXycDhrwnZe) 明天先验证一下运行态的沙箱数据接口能不能在设计态接口环境跑通，然后看下有哪些需要后端额外提供的接口和@陈多  对齐一下 这个需求的另一个技术方案，页面版本管理，可以后续当成一个独立的需求做，两个方案不冲突。技术侧的一些初步的输入可以看这个文档的方案二 [预览问题技术解决方案](https://bytedance.feishu.cn/docx/KtAjduXpVoO0bsxT0jocRxrInbh)。具体的产品形态，还需要产品侧统一看一下cc@李立刚  @陶春蕾 

### 明日计划

- 验证沙箱数据接口能否在设计态接口环境跑通
- 需要后端额外提供的接口
- 自定义组件引用收集

---

## 2月16日

| 工作事项                                 | 进度         | 项目                         | 文档                                                         | 工作量 | 协作者 |
| ---------------------------------------- | ------------ | ---------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 梳理一体化编辑器草稿预览对后端的接口依赖 | ✅ 已完成     | Kunlun Builder, 一体化编辑器 | [一体化编辑器技术文档（Builder部分文档）](https://bytedance.feishu.cn/docx/THQUdsFRioh7K2xuuXycDhrwnZe) | S      |        |
| 重新评估草稿态预览需求合理性             | 📈 连续到明天 | Kunlun Builder, 一体化编辑器 |                                                              |        |        |
| 增加自定义组件引用收集                   | ✅ 已完成     | Kunlun Builder, 元数据引用   | [feat: 增加自定义组件引用收集](https://code.byted.org/nclc-platform/kunlun-builder/commit/9fb436830196ab6f745bc7358b308a12cf165428) | XS     |        |
| 电商自定义组件梳理                       | 📈 连续到明天 | Kunlun Builder, DX兼容       | [电商自定义组件梳理](https://bytedance.feishu.cn/docx/FV7Yd7PKsoyvh8xKjvIc1pknnFc) | XL     |        |
| 预览问题技术解决方案                     | ✅ 已完成     | Kunlun Builder, 一体化编辑器 | [预览问题技术解决方案](https://bytedance.feishu.cn/docx/KtAjduXpVoO0bsxT0jocRxrInbh) | M      |        |

### 笔记

- [一体化编辑器技术文档（Builder部分文档）](https://bytedance.feishu.cn/docx/THQUdsFRioh7K2xuuXycDhrwnZe) 
- [电商自定义组件梳理](https://bytedance.feishu.cn/docx/FV7Yd7PKsoyvh8xKjvIc1pknnFc) 
- [预览问题技术解决方案](https://bytedance.feishu.cn/docx/KtAjduXpVoO0bsxT0jocRxrInbh) 

---

## 2月15日

| 工作事项                                 | 进度         | 项目                         | 文档                                                         | 工作量 | 协作者 |
| ---------------------------------------- | ------------ | ---------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 一体化编辑器技术文档（部分文档）         | 📈 连续到明天 | Kunlun Builder, 一体化编辑器 | [一体化编辑器技术文档（部分文档）](https://bytedance.feishu.cn/docx/THQUdsFRioh7K2xuuXycDhrwnZe) | M      |        |
| 修复自动保存节流未生效                   | ✅ 已完成     | Kunlun Builder, 一体化编辑器 |                                                              |        |        |
| 跟进视图表页面引用无法被删除             | ✅ 已完成     | Kunlun Builder, 元数据引用   |                                                              |        |        |
| 修复自动保存服务节流失效并限制接口作用域 | ✅ 已完成     | Kunlun Builder, 一体化编辑器 | [fix: 修复自动保存服务节流失效并限制接口作用域](https://code.byted.org/nclc-platform/kunlun-builder/commit/8c41f4535c303d87c7718bd23f0afe6942dee4f9) | S      |        |
| 防止页面未加载完成时保存                 | ✅ 已完成     | Kunlun Builder, 一体化编辑器 | [fix: 防止页面未加载完成时保存](https://code.byted.org/nclc-platform/kunlun-builder/commit/bdcd626533b3c683f5722a3a07563ec6cf734d5e) | XS     |        |
| 草稿态预览需求问题描述与解决方案         | ⏱ 推迟一天   | Kunlun Builder, 一体化编辑器 |                                                              |        |        |

### 笔记

- [一体化编辑器技术文档（部分文档）](https://bytedance.feishu.cn/docx/THQUdsFRioh7K2xuuXycDhrwnZe) 
- 视图表页面无法被删除，排查后发现是视图表绑定到值系统的数据没有开启自动清理引用的选项 `cleanup: true`

### 明日计划

- 草稿态预览需求问题描述与解决方案（预览设计器mock数据，页面版本管理）
- 重新评估草稿态预览需求合理性，组织会议

---

## 2月14日

| 工作事项                                 | 进度       | 项目                         | 文档                                                         | 工作量 | 协作者 |
| ---------------------------------------- | ---------- | ---------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 一体化编辑器技术文档（部分文档）         | ⏱ 推迟一天 | Kunlun Builder, 一体化编辑器 | [一体化编辑器技术文档（部分文档）](https://bytedance.feishu.cn/docx/THQUdsFRioh7K2xuuXycDhrwnZe) |        |        |
| 整理自动保存回调逻辑                     | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [refactor: 整理自动保存回调逻辑](https://code.byted.org/nclc-platform/kunlun-builder/commit/60144ea5955fdb5ea1f150eeecdf88a523c2cb8c) | S      |        |
| 自动保存服务移入maker-service            | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [refactor: 自动保存服务移入maker-service](https://code.byted.org/nclc-platform/kunlun-builder/commit/91e7a412f7a7c6a82977863b26e5a41e0bed03eb) | S      |        |
| 自动保存服务屏蔽内部状态                 | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [refactor: 自动保存服务屏蔽内部状态](https://code.byted.org/nclc-platform/kunlun-builder/commit/8532f74244b0f5ccf37c57d5570f7fc9a6a2e1cb) | XS     |        |
| 自动保存服务增加注释                     | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [chore: 自动保存服务增加注释](https://code.byted.org/nclc-platform/kunlun-builder/commit/0d982c909ab817a5a8eb5bdcad2b91b40afdbc3d) | XS     |        |
| 保存钩子处理函数抽离插件                 | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [refactor: 保存钩子处理函数抽离插件](https://code.byted.org/nclc-platform/kunlun-builder/commit/5c3f09d973a6d64538a68a093088ed3f0ab52966) | S      |        |
| 自动保存在页面数据初始化后出发状态初始化 | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [fix: 自动保存在页面数据初始化后出发状态初始化](https://code.byted.org/nclc-platform/kunlun-builder/commit/633fbf72fb9682a640ddf1c3b29956e3ce122043) | XS     |        |
| 页面变量初始化完成前不触发更新回调       | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [feat: 页面变量初始化完成前不触发更新回调](https://code.byted.org/nclc-platform/kunlun-builder/commit/930f7c1eed0e914ed08db099072a53b1624c041d) | S      | 禹慧慧 |
| i18n接入自动保存服务                     | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [feat: i18n接入自动保存服务](https://code.byted.org/nclc-platform/kunlun-builder/commit/fa308250ca04dca54a28e85280b7b27a18657a88) | M      | 周冰玲 |
| 修复i18n点击后无更改触发自动保存         | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [fix: 修复i18n点击后无更改触发自动保存](https://code.byted.org/nclc-platform/kunlun-builder/commit/2186895e2cfb8978e473b56bb5450988867ad966) | XS     | 周冰玲 |
| 页面配置接入自动保存服务                 | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [feat: 页面配置接入自动保存服务](https://code.byted.org/nclc-platform/kunlun-builder/commit/a88c2a91deb728b5fbd488f76ff35b77b769ce1a) | S      | 钟奇晟 |
| 修复页面配置选择icon后上传时阻塞页面进程 | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [perf: 修复页面配置选择icon后上传时阻塞页面进程](https://code.byted.org/nclc-platform/kunlun-builder/commit/82982f6f62146aaa8f5ed7900516ad8790a2acb3) | S      | 钟奇晟 |
| 修复页面配置修改会触发两次自动保存       | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [fix: 修复页面配置修改会触发两次自动保存](https://code.byted.org/nclc-platform/kunlun-builder/commit/d149c39064f6131a2070cb3a468467d48b466a66) | XS     | 钟奇晟 |

### 明日计划

- 自动保存节流未生效
- 一体化编辑器技术文档（部分文档）

---

## 2月13日

| 工作事项                           | 进度         | 项目                     | 文档                                                         | 工作量 | 协作者 |
| ---------------------------------- | ------------ | ------------------------ | ------------------------------------------------------------ | ------ | ------ |
| 跟进2.0支持第三方鉴权需求支持      | ⏱ 推迟一天   | Kunlun Builder, 权限     |                                                              |        |        |
| 了解kunlun接入第三方鉴权技术方案   | ✅ 已完成     | Kunlun Builder, 权限     | [[权限\][技术方案]Permission支持三方鉴权](https://bytedance.feishu.cn/wiki/wikcngYd6Z94pmUqepxGTh2E74e) | S      |        |
| 了解Rehaje融合2.0方案推演          | 📈 连续到明天 | Kunlun Builder, 组件规范 | [Rehaje & Builder2.0 可行性推演](https://bytedance.feishu.cn/docx/Ox77daMwbo36jaxNvA3cuvBBnlb) |        |        |
| 了解Rehaje渲染引擎                 | 📈 连续到明天 | Kunlun Builder, 组件规范 | [Rehaje 渲染引擎](https://bytedance.feishu.cn/docx/KDVQdgkyFoIOLXxrs1acrvFJnyd) |        |        |
| 阅读Rehaje代码                     | 📈 连续到明天 | Kunlun Builder, 组件规范 | https://code.byted.org/rehaje/rehaje.git                     |        |        |
| 跟进BOE频繁出现mapping接口异常问题 | ✅ 已完成     | Kunlun Builder, 全局     |                                                              | S      |        |
| 复合组件能力缺失文档               | ✅ 已完成     | Kunlun Builder, 复合组件 | [复合组件能力缺失](https://bytedance.feishu.cn/docx/Zba7dw6ouowHDexBC65chOW4nLb) | M      |        |
| 检查小组现有任务                   | ✅ 已完成     | Kunlun Builder, 全局     | [任务梳理2023年02月10日](https://bytedance.feishu.cn/wiki/wikcnPpJzuON0iWeuPKxO4EL0yc) |        |        |

### 笔记

- [复合组件能力缺失](https://bytedance.feishu.cn/docx/Zba7dw6ouowHDexBC65chOW4nLb) 
- BOE环境频繁出现`mapping`接口异常。
  -  原因是有同学用视图表的后端泳道`boe_vtable`在`builder2_2`这个应用调试，产生了很多脏数据。上次`builder2_1`应用是这样被遗弃的。
  -  所以视图表的开发和测试同学以后要注意下最好去别的应用调试和验收，以免影响到在共享应用下验收的测试和产品同学。
  -  这期的问题应该会在视图表的后端分支上线后正常。临时解决方案有三个：
  - 受影响的同学暂时另开一个新应用开发和验收需求
  - BOE环境把后端泳道切到 `boe_vtable`
  - 开发环境加上请求头 `"X-Tt-Env": "boe_vtable"`

---

## 2月10日

| 工作事项                                         | 进度     | 项目                 | 文档                                                         | 工作量 | 协作者 |
| ------------------------------------------------ | -------- | -------------------- | ------------------------------------------------------------ | ------ | ------ |
| 数据表格无应用全局字段权限影响设计侧展示问题排查 | ✅ 已完成 | Kunlun Builder, 权限 |                                                              | S      |        |
| 梳理手头需跟进的项目                             | ✅ 已完成 | Kunlun Builder, 全局 | [任务梳理2023年02月10日](https://bytedance.feishu.cn/wiki/wikcnPpJzuON0iWeuPKxO4EL0yc) | M      |        |
| 梳理一体化编辑器草稿预览自动保存依赖项           | ✅ 已完成 | Kunlun Builder, 全局 |                                                              | M      |        |

## 项目跟进

- 「🛏 未开始」2.0支持第三方鉴权
  - [[权限\][技术方案]Permission支持三方鉴权](https://bytedance.feishu.cn/wiki/wikcngYd6Z94pmUqepxGTh2E74e) 
  - [【技术方案】「支持三方鉴权」FE](https://bytedance.feishu.cn/wiki/wikcnPndBrwIAIIOgi6McAdcVkf) 
- 「🛏 未开始」一体化编辑器，实时保存，草稿预览，用户手动提交沙箱态
  - https://meego.feishu.cn/apaas_/story/detail/8478005
  - [一体化编辑器 - 草稿保存、加锁机制（评审通过）](https://bytedance.feishu.cn/wiki/wikcnooAYd9MGwG5Td5SnuTVQNg) 
  - [一体化编辑器「草稿 + 编辑锁」改动汇总](https://bytedance.feishu.cn/docx/ZPBQdz1G2otfOwxSrXgcUQi6nFg) 
  - [UX-aPaaS-一体化编辑器框架导航优化（评审通过）](https://bytedance.feishu.cn/wiki/wikcnYRViGoZBRi7OO3QwVm0eYf) 
  - 依赖项：
    - 页面变量初始化完成回调函数注册
    - 国际化面板CURD与初始化回调函数注册
    - 发布态页面列表接口（需要过滤掉所有未发布页面）
- 「🛏 未开始」前端API ID治理专项
  - [前端模块划分及Builder1.0下线时间对齐](https://bytedance.feishu.cn/docx/WTEcdztrNoEnMVxwKHEcQGapnJd) 
  - [aPaaS APIID治理专项Kickoff](https://bytedance.feishu.cn/docx/ZaL6dWtnxoUg1KxlIYQcQrh7nYw) 
  - [URL 规范改造技术方案设计](https://bytedance.feishu.cn/docx/RPe1d2XXYoiKbmxKDrsc3cWungb) 
  - [ID 、API ID、API Name 现状问题 case 分析](https://bytedance.feishu.cn/docx/Dr6odwWfroJCM2xmxQWcA1SRnzd) 
- 「🛏 未开始」支持有引用记录的应用生成安装包链接
  - [【PRD】应用增长 - 支持有引用记录的应用生成安装包链接 - 第 1 次议会评审](https://bytedance.feishu.cn/docx/doxcnxHruxtWqdMSWyPUy5be5Th) 
  - [技术方案 - Builder 支持引用记录的链接安装](https://bytedance.feishu.cn/docx/NdRmdjtbHov8dHxUcZfcbSwQnsh) 
  - [场景梳理 - UI 支持引用记录的链接安装](https://bytedance.feishu.cn/docx/LaKIdxlneo8fPjxEiPpcp9FYnfe) 
  - [【技术方案】支持有引用记录的应用生成安装包链接](https://bytedance.feishu.cn/docx/Uj9qdMYXToqt8Lxq3yVcXdeNnfU) 
- 「🛠 进行中」低代码融合HTMLComponent，自定义组件引用收集
  - https://meego.feishu.cn/apaas_/story/detail/8516034
  - [低代码融合2期技术方案](https://bytedance.feishu.cn/docx/CsbTdeGtBooBYKxzwf7c85dKnVh) 
- 「🛠 进行中」无代码搭建复合组件
  - https://meego.feishu.cn/apaas_/story/detail/7035300
  - [【Builder 2.0】可重复使用的复合组件 - 宣讲版](https://bytedance.feishu.cn/docx/UNG2dTzfGo6YIuxyAjfc87bnn4f) 
- 「🛠 进行中」飞书卡片搭建，支持飞书评论引用收集
  - https://meego.feishu.cn/apaas_/story/detail/7352483?activeStateId=waiting_for_server_development
- 「✅ 已完成」视图表vtable引用收集
  - https://meego.feishu.cn/apaas_/story/detail/7482211
  - [视图表技术方案](https://bytedance.feishu.cn/docx/JFX0d1RyKoT1RBxaYLlcZFxdn4e) 

---

## 2月9日

| 工作事项                                         | 进度       | 项目                       | 文档                                                         | 工作量 | 协作者 |
| ------------------------------------------------ | ---------- | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 数据表格无应用全局字段权限影响设计侧展示问题排查 | ⏱ 推迟一天 | Kunlun Builder, 权限       |                                                              |        |        |
| 增加元数据类型与定位信息机制                     | ✅ 已完成   | Kunlun Builder, 元数据引用 | [feat: 增加元数据类型与定位信息机制](https://code.byted.org/nclc-platform/kunlun-builder/commit/39d9f4394a7429d17606ca0a891324ff788482ff) | S      |        |
| 增加定位节点信息                                 | ✅ 已完成   | Kunlun Builder, 元数据引用 | [feat: 增加定位节点信息](https://code.byted.org/nclc-platform/kunlun-builder/commit/db015874d8386e01196b96f3cc70b6b1dd023ca2) | M      |        |
| 增加引用路径节点标识信息                         | ✅ 已完成   | Kunlun Builder, 元数据引用 | [feat: 增加引用路径节点信息](https://code.byted.org/nclc-platform/kunlun-builder/commit/51f4278a5434847e987701331ae114673d2c816f) | S      |        |
| HTML组件与JS动作接入引用收集与路径               | ✅ 已完成   | Kunlun Builder, 元数据引用 |                                                              | M      |        |
| 去除定位器对label和i18n的依赖                    | ✅ 已完成   | Kunlun Builder, 元数据引用 | [feat: 去除定位器对label和i18n的依赖](https://code.byted.org/nclc-platform/kunlun-builder/commit/369905988c83eea06f0b63a9654fad89a084a03c) | XS     |        |
| 增加定位节点语义化                               | ✅ 已完成   | Kunlun Builder, 元数据引用 | [perf: 增加定位节点语义化](https://code.byted.org/nclc-platform/kunlun-builder/commit/e59f7aea8ea40876bebba3666e6a4f30468c75a5) | S      |        |
| 传给后端的路径信息key转换为snake命名             | ✅ 已完成   | Kunlun Builder, 元数据引用 | [perf: 传给后端的路径信息key转换为snake命名](https://code.byted.org/nclc-platform/kunlun-builder/commit/16912970ee44114d7aabbcad0df31f95793e2333) | S      |        |
| 优化传给后端的路径参数类型                       | ✅ 已完成   | Kunlun Builder, 元数据引用 | [perf: 优化传给后端的路径参数类型](https://code.byted.org/nclc-platform/kunlun-builder/commit/fc19c57e3551246308e43c1125ae087c5782c68c) | S      |        |
| 修复数组检查类型入参错误                         | ✅ 已完成   | Kunlun Builder, 元数据引用 | [fix: 修复数组检查类型入参错误](https://code.byted.org/nclc-platform/kunlun-builder/commit/1db83038601cf5cb23ae3bc2fa8794c8bed74a50) | XS     |        |
| 组件规范评审-模型概念部分会议                    | ✅ 已完成   | Kunlun Builder, 组件规范   |                                                              |        |        |

### 明日计划

- 梳理手头需跟进的项目

---

## 2月8日

| 工作事项                 | 进度         | 项目                     | 文档                                                         | 工作量 | 协作者 |
| ------------------------ | ------------ | ------------------------ | ------------------------------------------------------------ | ------ | ------ |
| 内联页无权限bug跟进      | ⏰ 无限期推迟 | Kunlun Builder, 权限     |                                                              |        |        |
| 鉴权系统变量名与注释优化 | ✅ 已完成     | Kunlun Builder, 权限     | [refactor: 鉴权系统变量名与注释优化](https://code.byted.org/nclc-platform/kunlun-builder/commit/9b47fb0fa2bac4e0c90345218e5f3e82257fcaf8?merge_request_iid=3271) | M      |        |
| 内联页无权限bug跟进      | 📈 连续到明天 | Kunlun Builder, 权限     |                                                              |        |        |
| 学习DDD+ADT思想          | ✅ 已完成     | Kunlun Builder, 组件规范 | [用DDD和ADT提升代码质量](https://juejin.cn/post/7070861333377499144) | M      |        |
| 学习领域驱动设计思想     | 📈 连续到明天 | Kunlun Builder, 组件规范 | [专业的领域驱动设计平台](https://3dhub.bytedance.net/camp/steps/step_by_step) | L      |        |

### 明日计划

- 数据表格无应用全局字段权限影响设计侧展示问题排查
- 学习领域驱动设计思想

---

## 2月7日

| 工作事项                   | 进度         | 项目                     | 文档                                                         | 工作量 | 协作者 |
| -------------------------- | ------------ | ------------------------ | ------------------------------------------------------------ | ------ | ------ |
| 内联页无权限bug跟进        | ⏱ 推迟一天   | Kunlun Builder, 权限     |                                                              |        |        |
| 类型声明修改同步到评审文档 | ✅ 已完成     | Kunlun Builder, 组件规范 | [Builder2.0组件开发规范升级[ing\]](https://bytedance.feishu.cn/wiki/wikcnQaHuJFN1JgfAMHL3kqmpzd#L66Cd4ySWoCm4ixMHNbctjVgnZd) | M      |        |
| 整理类型声明目录结构       | ✅ 已完成     | Kunlun Builder, 组件规范 | [refactor: 整理目录结构](https://code.byted.org/nclc/kunlun-component-demo/commit/631181e4947096c3a83ea4939f65fa8cafe76fe6) | M      |        |
| 修复类型引入错误           | ✅ 已完成     | Kunlun Builder, 组件规范 | [fix: 修复类型引入错误](https://code.byted.org/nclc/kunlun-component-demo/commit/6a41f0c85757ece5150b4b243418d77dc385743b) | XS     |        |
| enum与expand字段调整       | ✅ 已完成     | Kunlun Builder, 组件规范 | [chore: enum与expand字段调整](https://code.byted.org/nclc/kunlun-component-demo/commit/a266503a78bc4ece8ef1e2d54fb5b9ba917ad164) | L      |        |
| 组件规范最终评审           | ✅ 已完成     | Kunlun Builder, 组件规范 |                                                              |        |        |
| 学习领域驱动设计思想       | 📈 连续到明天 | Kunlun Builder, 组件规范 | [专业的领域驱动设计平台](https://3dhub.bytedance.net/camp/steps/step_by_step) | L      |        |

### 笔记

- [Builder2.0组件开发规范升级[ing\]](https://bytedance.feishu.cn/wiki/wikcnQaHuJFN1JgfAMHL3kqmpzd#L66Cd4ySWoCm4ixMHNbctjVgnZd) 

### 明日计划

- 内联页无权限bug跟进
- 学习领域驱动设计思想

---

## 2月6日

| 工作事项                       | 进度         | 项目                     | 文档                                                         | 工作量 | 协作者 |
| ------------------------------ | ------------ | ------------------------ | ------------------------------------------------------------ | ------ | ------ |
| 下拉选择组件升级梳理           | ✅ 已完成     | Kunlun Builder, 组件规范 | [下拉选择](https://bytedance.feishu.cn/docx/C28CdcqR3oHJ34x5ooqcv1P4nsc) | M      |        |
| 测试TS转JSON-Schema三方库      | ✅ 已完成     | Kunlun Builder, 组件规范 | [feat: typescript-json-schema test](https://code.byted.org/nclc/kunlun-component-demo/commit/979a6990c4b0b58ffc181b9117c5d4a002fd82f2) | M      |        |
| 根据第三次评审修改类型声明结构 | ✅ 已完成     | Kunlun Builder, 组件规范 | [模型类型声明](https://bytedance.feishu.cn/docx/AwI0dKW2IoWq9SxXVkmcZX5FnFd) | M      |        |
| 完善类型描述协议               | ✅ 已完成     | Kunlun Builder, 组件规范 | [类型描述协议0.1.1版本](https://bytedance.feishu.cn/wiki/wikcn3BMTxl8ayEP2cXZjMMNN6d) | S      |        |
| 组件属性Setter与类型梳理       | ⏰ 无限期推迟 | Kunlun Builder, 组件规范 | [组件属性Setter与类型梳理（非数据部分）](https://bytedance.feishu.cn/docx/DeGudUDNcoSBS0x5vqNcJN5Hn8G) |        |        |
| 修改代码中类型声明结构         | ✅ 已完成     | Kunlun Builder, 组件规范 | [feat: update type declare struct](https://code.byted.org/nclc/kunlun-component-demo/commit/c2032284c92efe4ab2595f6559b874f5b6f11b40) |        |        |
| 类型声明修改同步到评审文档     | ⏱ 推迟一天   | Kunlun Builder, 组件规范 |                                                              |        |        |

### 明日计划

- 类型声明修改同步到评审文档
- 组件规范最终评审

---

## 2月2日 - 2月3日（休年假🏖️）

---

## 2月1日

| 工作事项                           | 进度       | 项目                     | 文档                                                         | 工作量 | 协作者 |
| ---------------------------------- | ---------- | ------------------------ | ------------------------------------------------------------ | ------ | ------ |
| 下拉选择组件升级梳理               | ⏱ 推迟一天 | Kunlun Builder, 组件规范 |                                                              |        |        |
| typeName类型结构支持引用与类型定义 | ✅ 已完成   | Kunlun Builder, 组件规范 | [Builder2.0组件开发规范升级[ing\]](https://bytedance.feishu.cn/wiki/wikcnQaHuJFN1JgfAMHL3kqmpzd#L66Cd4ySWoCm4ixMHNbctjVgnZd) |        |        |
| 组件属性领域模型（模型注册方式）   | ✅ 已完成   | Kunlun Builder, 组件规范 | [组件属性领域模型](https://bytedance.feishu.cn/docx/WsrMd3j8WoUWQRxzH0fcdbiAnSb) |        |        |
| 类型与JSON-Schema保持一致          | ✅ 已完成   | Kunlun Builder, 组件规范 | [模型类型声明](https://bytedance.feishu.cn/docx/AwI0dKW2IoWq9SxXVkmcZX5FnFd) |        |        |
| 基础类型格式对齐JSON-Schema        | ✅ 已完成   | Kunlun Builder, 组件规范 | [feat: 基础类型格式对齐JSON-Schema](https://code.byted.org/nclc/kunlun-component-demo/commit/06f32345be1a6cb765f58bd8b5690ccccf2be542) |        |        |

### 明日计划

- 下拉选择组件升级梳理