## 项目跟进

- 「🛏 未开始」自定义组件兼容
- 「🛏 未开始」自定义URL
- 「🛏 未开始」流量朔源
  - [[aPaaS.技术方案\] 流量溯源](https://bytedance.feishu.cn/docx/UkHddQoJFo1eXuxGiZ9cc3m8nqe?chatTab=1&useIframe=1&multiPage=1) 
- 「🛏 未开始」2.0支持第三方鉴权
  - https://meego.feishu.cn/apaas_/story/detail/9244041?parentUrl=%2Fworkbench#comment
  - [[权限\][技术方案]Permission支持三方鉴权](https://bytedance.feishu.cn/wiki/wikcngYd6Z94pmUqepxGTh2E74e) 
  - [【技术方案】「支持三方鉴权」FE](https://bytedance.feishu.cn/wiki/wikcnPndBrwIAIIOgi6McAdcVkf) 
- 「🛏 未开始」支持有引用记录的应用生成安装包链接
  - [【PRD】应用增长 - 支持有引用记录的应用生成安装包链接 - 第 1 次议会评审](https://bytedance.feishu.cn/docx/doxcnxHruxtWqdMSWyPUy5be5Th) 
  - [技术方案 - Builder 支持引用记录的链接安装](https://bytedance.feishu.cn/docx/NdRmdjtbHov8dHxUcZfcbSwQnsh) 
  - [场景梳理 - UI 支持引用记录的链接安装](https://bytedance.feishu.cn/docx/LaKIdxlneo8fPjxEiPpcp9FYnfe) 
  - 依赖项
    - 设计态错误检查
    - 组件属性定位功能
- 「🛏 未开始」页面复制
  - https://meego.feishu.cn/apaas_/story/detail/9999659
- 「🛠 进行中」无代码搭建复合组件
  - https://meego.feishu.cn/apaas_/story/detail/7035300
  - [【Builder 2.0】可重复使用的复合组件 - 宣讲版](https://bytedance.feishu.cn/docx/UNG2dTzfGo6YIuxyAjfc87bnn4f) 
  - [Figma-复合组件设计稿](https://www.figma.com/file/WeQidAuav41EnfReTIyB1Y/branch/NRP6Oz1OV99mjlDqxuPbi5/Web?node-id=10830-222118&t=NZql8M2MNDzPCi2E-0)
  - [复合组件一期需求研发节奏](https://bytedance.feishu.cn/wiki/wikcnKLJCMEIf4JjaEFr8MaMJrc?chatTab=1&useIframe=1&multiPage=1) 
  - [UX拆解](https://bytedance.feishu.cn/wiki/wikcnN2ZC3iEJLpxtdp4hozDvhe?chatTab=1&useIframe=1&multiPage=1) 
- 「🛠 进行中」bindData治理
  - https://meego.feishu.cn/apaas_/story/detail/9818870
  - [bindData问题确认](https://bytedance.feishu.cn/wiki/wikcnrlJBVeuCkbWQhRBt28BRvY?from=space_personal_filelist&pre_pathname=%2Fdrive%2Ffolder%2FfldcnUCfu8c1Ck51vP2cC0vB4db) 
  - [bindData治理技术方案](https://bytedance.feishu.cn/docx/GVSndHPkXoSGUvxSsy6ct4j7nMb) 
- 「🛠 进行中」子页面拆分
  - [子页面拆分面临问题](https://bytedance.feishu.cn/docx/XAY8dzRDXoBhUMxpM0FcRK0Unsc) 
  - [Builder 2.0子页面拆分进展（3.3）](https://bytedance.feishu.cn/docx/MCrMdVmrzoxLQgx6tjFclxN4nWh) 
- 「🛠 进行中」前端API ID治理专项
  - [APIID统一生成规则方案](https://bytedance.feishu.cn/docx/Y4fBd8kwFotbJRx7m7VcZiK7nvf?chatTab=1&useIframe=1&multiPage=1) 
  - [前端模块划分及Builder1.0下线时间对齐](https://bytedance.feishu.cn/docx/WTEcdztrNoEnMVxwKHEcQGapnJd) 
  - [aPaaS APIID治理专项Kickoff](https://bytedance.feishu.cn/docx/ZaL6dWtnxoUg1KxlIYQcQrh7nYw) 
  - [URL 规范改造影响范围](https://bytedance.feishu.cn/docx/RPe1d2XXYoiKbmxKDrsc3cWungb) 
  - [ID 、API ID、API Name 现状问题 case 分析](https://bytedance.feishu.cn/docx/Dr6odwWfroJCM2xmxQWcA1SRnzd) 
- 「✅ 已完成」一体化编辑器，实时保存，草稿预览，用户手动提交沙箱态
  - https://meego.feishu.cn/apaas_/story/detail/8478005
  - [一体化编辑器 - 草稿保存、加锁机制（评审通过）](https://bytedance.feishu.cn/wiki/wikcnooAYd9MGwG5Td5SnuTVQNg) 
  - [一体化编辑器「草稿 + 编辑锁」改动汇总](https://bytedance.feishu.cn/docx/ZPBQdz1G2otfOwxSrXgcUQi6nFg) 
  - [UX-aPaaS-一体化编辑器框架导航优化（评审通过）](https://bytedance.feishu.cn/wiki/wikcnYRViGoZBRi7OO3QwVm0eYf) 
  - [Figma-一体化编辑器UX设计稿](https://www.figma.com/file/x9qsFIizOZfgT0oQqh4uDI/一体化专项?node-id=559%3A269336&t=UXWA4ZoFIgqCj8lC-1)
  - 依赖项：
    - ✅ 页面变量初始化完成回调函数注册
    - ✅ 国际化面板CURD与初始化回调函数注册
    - 发布态页面列表接口（需要过滤掉所有未发布页面）
  - 分支 `feature-aio-editor`：
    - 自动保存服务 `refactor-auto-save-service`
    - 草稿预览功能 `feature-draft-preview`
    - Header还原UI设计稿 `perf-kunlun-header-ui`
    - 统一保存接口 `feature-centralized-update`

---

## 3月31日（生病请假😢）

---

## 3月30日

| 工作事项                       | 进度       | 项目                     | 文档                                                         | 工作量 | 协作者 |
| ------------------------------ | ---------- | ------------------------ | ------------------------------------------------------------ | ------ | ------ |
| 整理日报（3.27-3.30）          | ✅ 已完成   |                          |                                                              |        |        |
| 引用收集细排                   | ✅ 已完成   |                          |                                                              | S      | 唐词伟 |
| 整理OKR                        | ⏱ 推迟一天 |                          |                                                              |        |        |
| 删除默认组件id配置             | ✅ 已完成   | Kunlun Builder, 复合组件 | [chore: 删除默认组件id配置](https://code.byted.org/nclc-platform/kunlun-builder/commit/d2a3cc445e89e3578e0d569909eca1d84c7ebfc6) | S      |        |
| 复合组件类型icon与label生成    | ✅ 已完成   | Kunlun Builder, 复合组件 | [feat: 复合组件类型icon与label生成](https://code.byted.org/nclc-platform/kunlun-builder/commit/725586c33dae5b896ae8fdf99bb72424bcfd951a) | M      |        |
| 输出属性接入类型icon           | ✅ 已完成   | Kunlun Builder, 复合组件 | [feat: 输出属性接入类型icon](https://code.byted.org/nclc-platform/kunlun-builder/commit/277b81cbc9c7085d6f353598ebc139610c9c9a9e) | S      |        |
| 复合组件模型层增加lib注册机制  | ✅ 已完成   | Kunlun Builder, 复合组件 | [feat: 复合组件模型层增加lib注册机制](https://code.byted.org/nclc-platform/kunlun-builder/commit/061ebfbb96a25aabf04ed48cfe200373bb856038) | M      |        |
| 去除写死的类型                 | ✅ 已完成   | Kunlun Builder, 复合组件 | [perf: 去除写死的类型](https://code.byted.org/nclc-platform/kunlun-builder/commit/077aeb835993a4de2d450f81ff4a3cc0f36ff400) | S      |        |
| 复合组件适配记录类型           | ✅ 已完成   | Kunlun Builder, 复合组件 | [feat: 复合组件适配记录类型](https://code.byted.org/nclc-platform/kunlun-builder/commit/f6d7fae84172e8056e50c8bfdda0862486701561) | S      |        |
| 修复禁用逻辑取反               | ✅ 已完成   | Kunlun Builder, 复合组件 | [fix: 修复禁用逻辑取反](https://code.byted.org/nclc-platform/kunlun-builder/commit/8f4e6a7511689db7aec597efc4cbabede61c0eae) | XS     |        |
| 修复页面编辑器去除复合组件收集 | ✅ 已完成   | Kunlun Builder, 复合组件 | [fix: 修复页面编辑器去除复合组件收集](https://code.byted.org/nclc-platform/kunlun-builder/commit/e861f18157d0bb66828b0b1c80123837535f9d64) | XS     |        |
| 修复属性名称未填校验通过       | ✅ 已完成   | Kunlun Builder, 复合组件 | [fix: 修复属性名称未填校验通过](https://code.byted.org/nclc-platform/kunlun-builder/commit/796f1677bb5de036398846ff5af3086790bd6cfc) | S      |        |
| 属性类型必选                   | ✅ 已完成   | Kunlun Builder, 复合组件 | [fix: 属性类型必选](https://code.byted.org/nclc-platform/kunlun-builder/commit/8118988f3ac78b50eb6fc960aba7a96dbfda6670) | XS     |        |
| 复合组件属性面板样式走查       | ⏱ 推迟一天 | Kunlun Builder, 复合组件 |                                                              |        |        |
| 无法识别的类型走旧类型逻辑     | ✅ 已完成   | Kunlun Builder, 复合组件 | [perf: 无法识别的类型走旧类型逻辑](https://code.byted.org/nclc-platform/kunlun-builder/commit/2e44ed6c25c1cc153f5e90251d27afb8efbaf027) | M      |        |

### 笔记

- 引用收集排期（共27人日）
  - 技术方案设计与评审 5人日
  - 开发
    - 引用收集架构重构与整理 5人日
    - 收集元数据是被哪些组件引用的信息 4人日
    - 收集i18n中的组件信息 5人日
    - 删除引用跳转定位功能 3人日
  - 测试与BUG修复 5人日



---

## 3月29日

| 工作事项                               | 进度       | 项目                     | 文档                                                         | 工作量 | 协作者 |
| -------------------------------------- | ---------- | ------------------------ | ------------------------------------------------------------ | ------ | ------ |
| 复合组件引用收集                       | ✅ 已完成   | Kunlun Builder, 复合组件 | [feat: 复合组件引用收集](https://code.byted.org/nclc-platform/kunlun-builder/commit/4fdd678d2ff6d7866896b67c9cf93ff7d25db193) | S      |        |
| 修复组件暴露属性类型无映射导致页面崩溃 | ✅ 已完成   | Kunlun Builder, 复合组件 | [fix: 修复组件暴露属性类型无映射导致页面崩溃](https://code.byted.org/nclc-platform/kunlun-builder/commit/85a7ef60b484dd67b1bd2e4b422187a69fa12e28) | S      |        |
| 复合组件类型收口                       | ✅ 已完成   | Kunlun Builder, 复合组件 | [feat: 复合组件类型收口](https://code.byted.org/nclc-platform/kunlun-builder/commit/ad9dc7a2a80a31b529cb6e27b3d2abc323f16f1e) | M      |        |
| 复合组件类型默认值                     | ✅ 已完成   | Kunlun Builder, 复合组件 | [feat: 复合组件类型默认值](https://code.byted.org/nclc-platform/kunlun-builder/commit/60a444c3c3c9b62f18cea6689dd5e6daf92fcdab) | M      |        |
| 复合组件属性面板样式走查               | ⏱ 推迟一天 | Kunlun Builder, 复合组件 |                                                              |        |        |

### 明日计划

- 复合组件类型icon与label生成

---

## 3月28日

| 工作事项                         | 进度       | 项目                     | 文档                                                         | 工作量 | 协作者 |
| -------------------------------- | ---------- | ------------------------ | ------------------------------------------------------------ | ------ | ------ |
| 更改默认值的key                  | ✅ 已完成   | Kunlun Builder, 复合组件 | [feat: 更改默认值的key](https://code.byted.org/nclc-platform/kunlun-builder/commit/acf25159fa5e089474e6ead1a16dd34812cfff0a) | S      |        |
| 复合组件模型更改触发写入designer | ✅ 已完成   | Kunlun Builder, 复合组件 | [feat: 复合组件模型更改触发写入designer](https://code.byted.org/nclc-platform/kunlun-builder/commit/c34a5bbbea47e2c85373a3a6da0b5eeaecb1c799) | M      |        |
| 复合组件根节点默认值配置功能     | ✅ 已完成   | Kunlun Builder, 复合组件 | [feat: 复合组件根节点默认值配置功能](https://code.byted.org/nclc-platform/kunlun-builder/commit/bca99dfc381f8c7f97f5621d1d839624564afedc) | M      |        |
| 修复更新默认属性造成setProps失效 | ✅ 已完成   | Kunlun Builder, 复合组件 | [fix: 修复更新默认属性造成setProps失效](https://code.byted.org/nclc-platform/kunlun-builder/commit/0f8205ee316f06d51378801afd5cfa4384eeb1b4) | S      |        |
| 修复新建属性后失去setProps       | ✅ 已完成   | Kunlun Builder, 复合组件 | [fix: 修复新建属性后失去setProps](https://code.byted.org/nclc-platform/kunlun-builder/commit/19afbef94b678c0a75d2a09aa93a7a9e7232f8ca) | XS     |        |
| 复合组件引用收集                 | ⏱ 推迟一天 | Kunlun Builder, 复合组件 |                                                              |        |        |

### 明日计划

- 复合组件引用收集
- 复合组件类型收口

---

## 3月27日

| 工作事项                        | 进度       | 项目                     | 文档                                                         | 工作量 | 协作者 |
| ------------------------------- | ---------- | ------------------------ | ------------------------------------------------------------ | ------ | ------ |
| 线上发Hotfix                    | ✅ 已完成   | Kunlun Builder, 全局     | https://bytecycle.bytedance.net/space/kunlun_builder_train/module/release_train/train/detail/133227?ticketType=normal | M      | 王松   |
| C360发Hotfix                    | ✅ 已完成   | Kunlun Builder, 全局     | https://code.byted.org/nclc-platform/kunlun-builder/merge_requests/3772/commits | S      | 王松   |
| 复合组件根节点迁入v2组件        | ✅ 已完成   | Kunlun Builder, 复合组件 | [refactor: 复合组件根节点迁入v2组件](https://code.byted.org/nclc-platform/kunlun-builder/commit/1363f9b7c880169069fa524c847eccfe6aab129a) | M      |        |
| 更换根节点为页面容器            | ✅ 已完成   | Kunlun Builder, 复合组件 | [chore: 更换根节点为页面容器](https://code.byted.org/nclc-platform/kunlun-builder/commit/3c2f307c9ce257e77cddb34c39a6485f94ff1a14) | M      |        |
| 表单方案默认值更改              | ✅ 已完成   | Kunlun Builder, 复合组件 | [chore: 表单方案默认值更改](https://code.byted.org/nclc-platform/kunlun-builder/commit/53d995a62272b451b3b558b9e8ae68345e675e6f) | S      |        |
| 适配产品正则规则                | ✅ 已完成   | Kunlun Builder, 复合组件 | [chore: 适配产品正则规则](https://code.byted.org/nclc-platform/kunlun-builder/commit/6f339fed47d6e6d3f4df03d7d5b5ce5ebf45a823) | S      |        |
| meta相关connector参数表增加前缀 | ✅ 已完成   | Kunlun Builder, 复合组件 | [chore: meta相关connector参数表增加前缀](https://code.byted.org/nclc-platform/kunlun-builder/commit/8eae8eda564d08c140ab6b6dbbc644e0c7a9028b) | S      |        |
| 修复自测清淡问题                | ⏱ 推迟一天 | Kunlun Builder, 复合组件 |                                                              |        |        |

### 明日计划

- 复合组件模型更改触发写入designer
- 复合组件根节点默认值配置功能
- 复合组件引用收集

---

## 3月26日（加班😩）

| 工作事项                       | 进度     | 项目                     | 文档                                                         | 工作量 | 协作者 |
| ------------------------------ | -------- | ------------------------ | ------------------------------------------------------------ | ------ | ------ |
| 复合组件meta.data模块命名调整  | ✅ 已完成 | Kunlun Builder, 复合组件 | [chore: 复合组件meta.data模块命名调整](https://code.byted.org/nclc-platform/kunlun-builder/commit/b5bc615ee7fc83b90174a68ba7f70630357627a9) | S      |        |
| 导出属性适配新规范             | ✅ 已完成 | Kunlun Builder, 复合组件 | [refactor: 导出属性适配新规范](https://code.byted.org/nclc-platform/kunlun-builder/commit/d9c5a25da1fb800d95bef6d3eef6b6e945703594) | S      |        |
| 禁用无权限报错横幅             | ✅ 已完成 | Kunlun Builder, 权限     | [perf: 禁用无权限报错横幅](https://code.byted.org/nclc-platform/kunlun-builder/commit/cb957b7889a077410bd2bea536e784dd9f27930d) | S      |        |
| 在身份模拟隐藏时不请求页面列表 | ✅ 已完成 | Kunlun Builder, 权限     | [fix: 根据是否展示身份模拟来决定是否拉取数据](https://code.byted.org/nclc-platform/kunlun-builder/commit/51fd4b9b5abad904d581bbb82412ef1898169cd3) | XS     |        |
| 线上环境彻底屏蔽身份模拟插件   | ✅ 已完成 | Kunlun Builder, 权限     | [chore: 线上环境彻底屏蔽身份模拟插件](https://code.byted.org/nclc-platform/kunlun-builder/commit/569dbd9f275961018f8b487ae5639d6bc6846bd8) | S      |        |

### 笔记

- 线上的身份模拟调用的页面列表接口挂掉了，解决方案
  - 线上环境禁用身份模拟插件
  - 运行时页面列表接口接入，去除请求头写死designer中间件

### 明日计划

- 复合组件类型相关结构收口到一处
- 修复[复合组件-自测清单](https://bytedance.feishu.cn/wiki/LCRlwCIMqixIiVkZmMmcdmJsnAd) 问题

---

## 3月24日

| 工作事项                             | 进度       | 项目                     | 文档                                                         | 工作量 | 协作者 |
| ------------------------------------ | ---------- | ------------------------ | ------------------------------------------------------------ | ------ | ------ |
| 复合组件管理器接入接口               | ✅ 已完成   | Kunlun Builder, 复合组件 | [feat: 复合组件管理器接入接口](https://code.byted.org/nclc-platform/kunlun-builder/commit/dc910964226f4ed1c84193be952058e45e105fa1) | S      |        |
| 复合组件模型接入自动保存与数据持久化 | ✅ 已完成   | Kunlun Builder, 复合组件 | [feat: 复合组件模型接入自动保存与数据持久化](https://code.byted.org/nclc-platform/kunlun-builder/commit/5a4f0d6919d0c2b5fcfac2dc1a4b6aaea7a35d97) | M      |        |
| 更新复合组件模型类型标识             | ✅ 已完成   | Kunlun Builder, 复合组件 | [feat: 更新复合组件模型类型标识](https://code.byted.org/nclc-platform/kunlun-builder/commit/81a58e9f3901b59844b890170911377fe40b6b5b) | XS     |        |
| 提交组件接入保存提交接口             | ✅ 已完成   | Kunlun Builder, 复合组件 | [feat: 提交组件接入保存提交接口](https://code.byted.org/nclc-platform/kunlun-builder/commit/d5882af063b02071b6d4cf264635ca2597c08b67) | S      |        |
| 运行时注入bindData时序               | ⏱ 推迟一天 | Kunlun Builder, 全局     |                                                              |        |        |

### 笔记

- 运行时注入bindData时序导致值无法注入
  - bindData机制带来的，这个机制需要将值和组件属性解耦合，所以需要在属性解析前注入，带来这个看起来像“魔法”的修复，其实就是注入时序带来的。 问题很难发现，而且后续很难维护。 所以后面推进新版组件的时候要注意，不能再复用bindData的逻辑，直接存在属性里，就能完全避免掉这个问题
  - ![img](https://bytedance.larkoffice.com/space/api/box/stream/download/asynccode/?code=YmQ3NjUxNWI1MTExYzgzZmM5NTQyMjViMzUxMjBlMmNfNXI5ZGRzTERDQzh3M2dEUVp1ampFb1BNZ1EySzJKY0NfVG9rZW46TTZxUWJGRnNIb0hEM0h4eTUycGNGNnVybjJlXzE3MDAxMzM0OTk6MTcwMDEzNzA5OV9WNA)

### 明日计划

- Hotfix 运行时注入bindData时序

---

## 3月23日

| 工作事项                 | 进度     | 项目                     | 文档                                                         | 工作量 | 协作者 |
| ------------------------ | -------- | ------------------------ | ------------------------------------------------------------ | ------ | ------ |
| 模型模块间结构重构       | ✅ 已完成 | Kunlun Builder, 复合组件 | [refactor: 模型模块间结构重构](https://code.byted.org/nclc-platform/kunlun-builder/commit/2b82f613352bf32dfafbcaf068b170b83f8989e1) | L      |        |
| 视图层适配模型结构更改   | ✅ 已完成 | Kunlun Builder, 复合组件 | [chore: 视图层适配模型结构更改](https://code.byted.org/nclc-platform/kunlun-builder/commit/8a2ddb02b781bb0a3f716b4c86c67b75a3ccb005) | S      |        |
| 增加输出属性标题拼接     | ✅ 已完成 | Kunlun Builder, 复合组件 | [feat: 增加输出属性标题拼接](https://code.byted.org/nclc-platform/kunlun-builder/commit/e8d158a73991b62d2d9104c62b3367c7b929421c) | XS     |        |
| 组件输出属性适配视图层   | ✅ 已完成 | Kunlun Builder, 复合组件 | [feat: 组件输出属性适配视图层](https://code.byted.org/nclc-platform/kunlun-builder/commit/440c786247085364ae744f5e5ca71d4bee321dfb) | M      |        |
| 更改props-setting命名    | ✅ 已完成 | Kunlun Builder, 复合组件 | [chore: 更改props-setting命名](https://code.byted.org/nclc-platform/kunlun-builder/commit/ac6a4009af79a4b4ab38af9918f7a29aa0c3f5f2) | XS     |        |
| 输出属性支持增量更新修改 | ✅ 已完成 | Kunlun Builder, 复合组件 | [feat: 输出属性支持增量更新修改](https://code.byted.org/nclc-platform/kunlun-builder/commit/a25e5ec221f0e6a9c8d9df68847b80c743caecbc) | M      |        |

### 明日计划

- 复合组件管理器接入接口
- 复合组件模型接入自动保存与数据持久化

---

## 3月22日

| 工作事项                 | 进度       | 项目                       | 文档                                                         | 工作量 | 协作者 |
| ------------------------ | ---------- | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 复合组件输出收集到模型   | ✅ 已完成   | Kunlun Builder, 复合组件   | [feat: 复合组件输出收集到模型](https://code.byted.org/nclc-platform/kunlun-builder/commit/894f4fea85bdd46c3cc06abbcbd24844c62d1350) | L      |        |
| 视图层适配模型结构更改   | ⏱ 推迟一天 | Kunlun Builder, 复合组件   |                                                              |        |        |
| 文本组件未接入元数据引用 | ✅ 已完成   | Kunlun Builder, 元数据引用 |                                                              |        |        |

### 笔记

- 阅读[Builder 2.0 集成发布流程说明](https://bytedance.feishu.cn/wiki/wikcnG8C8p6ieZNd4hVwul0seWf?from=from_lark_index_search) 

### 明日计划

- 组件输出属性适配视图层
- 输出属性支持增量更新修改

---

## 3月21日

| 工作事项                         | 进度     | 项目                         | 文档                                                         | 工作量 | 协作者      |
| -------------------------------- | -------- | ---------------------------- | ------------------------------------------------------------ | ------ | ----------- |
| 对齐草稿预览badcase              | ✅ 已完成 | Kunlun Builder, 一体化编辑器 |                                                              |        | 张帅,李立刚 |
| 画布外框高度溢出                 | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [fix: 修复模拟外框开启时画布高度不正确](https://code.byted.org/nclc-platform/kunlun-builder/commit/75a4b84675bab262f51e8c3a84c2d1a985c1c678?merge_request_iid=3678) | XS     |             |
| 草稿预览页接口环境切为设计态     | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [feat: 草稿预览页接口环境切为设计态](https://code.byted.org/nclc-platform/kunlun-builder/commit/f8d4fc9431a26a0a62d8dc6d51af21497ea1a2c2?merge_request_iid=3678) | S      |             |
| 禁用草稿预览身份模拟功能         | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [feat: 禁用草稿预览身份模拟功能](https://code.byted.org/nclc-platform/kunlun-builder/commit/94af8edf37aced7036384093b817c220774de461?merge_request_iid=3678) | M      |             |
| 在一体化外壳内才开启草稿预览     | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [chore: 在一体化外壳内才开启草稿预览](https://code.byted.org/nclc-platform/kunlun-builder/commit/27fbf96d5f85b336c9e5511fee387aaabd4caa15?merge_request_iid=3678) | XS     |             |
| preview/ns路径适配               | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [chore: preview/ns路径适配](https://code.byted.org/nclc-platform/kunlun-builder/commit/1f85a5a6263607754feda946881e1d6f1b492143?merge_request_iid=3678) | S      |             |
| 修复沙箱预览身份模拟带有禁用提示 | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [fix: 修复沙箱预览身份模拟带有禁用提示](https://code.byted.org/nclc-platform/kunlun-builder/commit/601b84b8b31100d2aa3ce7b660c26dec226cbea9?merge_request_iid=3678) | XS     |             |
| 修复非一体化模式时预览按钮样式   | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [fix: 修复非一体化模式时预览按钮样式](https://code.byted.org/nclc-platform/kunlun-builder/commit/6b9280045e22feb4a5fccbb274fc478cc88e4b3a?merge_request_iid=3678) | M      |             |
| 修复一体化模式调试判断           | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [fix: 修复一体化模式调试判断](https://code.byted.org/nclc-platform/kunlun-builder/commit/2acdb7be3b717bf2815caf5cdb1a4bb6000ff3aa?merge_request_iid=3678) | S      |             |
| 草稿预览需要手动刷新问题         | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [fix: 修复草稿预览需要手动刷新问题](https://code.byted.org/nclc-platform/kunlun-builder/commit/1c6ae360b04a4fcde42ff2fe80951a2e6b9a13df?merge_request_iid=3678) | S      |             |
| 点击预览再加载草稿预览页         | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [perf: 点击预览再加载草稿预览页](https://code.byted.org/nclc-platform/kunlun-builder/commit/f6a47e8e701d1a75c34d443e56991819423fff7a?merge_request_iid=3678) | XS     |             |
| 模拟无权限用户访问设计器报错     | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [fix: 模拟无权限用户访问设计器报错](https://code.byted.org/nclc-platform/kunlun-builder/commit/0ba9e19fcdd7151749026718e424b9e773056abe?merge_request_iid=3678) | S      |             |
| 产品文案优化与国际化文案补充     | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [perf: 增加国际化文案与UI适配](https://code.byted.org/nclc-platform/kunlun-builder/commit/d05bc2ced74fbbfceb3ee99864ebdf74a7caa1da?merge_request_iid=3678) | S      |             |
| 适配禁用身份模拟UI设计稿         | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [perf: 增加国际化文案与UI适配](https://code.byted.org/nclc-platform/kunlun-builder/commit/d05bc2ced74fbbfceb3ee99864ebdf74a7caa1da?merge_request_iid=3678) | S      |             |
| 修复权限数据未提交到后端         | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [fix: 修复权限数据未提交到后端](https://code.byted.org/nclc-platform/kunlun-builder/commit/a2611ef595e791839c069074cb25775cb6be42ba?merge_request_iid=3678) | XS     |             |
| 修复权限动态值未过滤类型         | ✅ 已完成 | Kunlun Builder, 权限         | [fix: 修复权限动态值未过滤类型](https://code.byted.org/nclc-platform/kunlun-builder/commit/08ea0b0e282c61f88c6783db8e9669fe21bd69e4) | M      | 孙浩维      |

### 明日计划

- 删除对象上字段的时候，如果字段被页面引用了，不会提示，也会删除成功
- 复合组件输出收集到模型

---

## 3月20日

| 工作事项               | 进度     | 项目                     | 文档                                                         | 工作量 | 协作者 |
| ---------------------- | -------- | ------------------------ | ------------------------------------------------------------ | ------ | ------ |
| 草稿预览页加载性能优化 | ✅ 已完成 | Kunlun Builder, 复合组件 | [feat: 草稿预览页加载性能优化](https://code.byted.org/nclc-platform/kunlun-builder/commit/403a6070e562f1598e5ec58840d0fe3c9bd01684) | XS     |        |
| 编辑组件属性功能       | ✅ 已完成 | Kunlun Builder, 复合组件 | [feat: 编辑组件属性功能](https://code.byted.org/nclc-platform/kunlun-builder/commit/5c7ae8b2b157adbd350534f3fbcd1795c7bef264) | L      |        |
| 删除组件属性功能       | ✅ 已完成 | Kunlun Builder, 复合组件 | [feat: 删除组件属性功能](https://code.byted.org/nclc-platform/kunlun-builder/commit/d1366a28e297ff08520ceceb8c86e9f213fa8553) | S      |        |
| 组件模型接入值系统     | ✅ 已完成 | Kunlun Builder, 复合组件 | [feat: 删除组件属性功能](https://code.byted.org/nclc-platform/kunlun-builder/commit/d1366a28e297ff08520ceceb8c86e9f213fa8553) | M      |        |

## 跟进

- 对齐草稿预览badcase
- 画布外框高度溢出
- preview/ns路径适配
- 草稿预览需要手动刷新问题
- 模拟无权限用户访问设计器报错
- 点击预览再加载草稿预览页

---

## 3月19日（加班😩）

| 工作事项                         | 进度     | 项目                     | 文档                                                         | 工作量 | 协作者 |
| -------------------------------- | -------- | ------------------------ | ------------------------------------------------------------ | ------ | ------ |
| 初始化属性添加表单功能           | ✅ 已完成 | Kunlun Builder, 复合组件 | [feat: 初始化属性添加表单功能](https://code.byted.org/nclc-platform/kunlun-builder/commit/7c5f444200f3c55a9c0d832ff1f7a279626f5b8e) | M      |        |
| 抽离属性设置面板非业务组件       | ✅ 已完成 | Kunlun Builder, 复合组件 | [refactor: 抽离属性设置面板非业务组件](https://code.byted.org/nclc-platform/kunlun-builder/commit/e408016b48cd5fe63a23263f341342366bde74b8) | S      |        |
| 草稿预览页加载性能优化           | ✅ 已完成 | Kunlun Builder, 复合组件 | [feat: 草稿预览页加载性能优化](https://code.byted.org/nclc-platform/kunlun-builder/commit/fc127ebb000dc3e71eeb7e8d7914e61709e67872) | XS     |        |
| 弹层位置适配一体化外框           | ✅ 已完成 | Kunlun Builder, 复合组件 | [fix: 弹层位置适配一体化外框](https://code.byted.org/nclc-platform/kunlun-builder/commit/7476ee6df900def83b936b4acc1b2adaff410e8c) | XS     |        |
| 增加表单生成类型声明             | ✅ 已完成 | Kunlun Builder, 复合组件 | [feat: 增加表单生成类型声明](https://code.byted.org/nclc-platform/kunlun-builder/commit/c56236ff83eb0a2db6d8257e32a3e33834796312) | M      |        |
| 增加初始化模型与更新meta信息方法 | ✅ 已完成 | Kunlun Builder, 复合组件 | [feat: 增加初始化模型与更新meta信息方法](https://code.byted.org/nclc-platform/kunlun-builder/commit/64ddcb970fbb02f90e642d80850f4252d95b4344) | L      |        |
| 模型增加初始值                   | ✅ 已完成 | Kunlun Builder, 复合组件 | [chore: 模型增加初始值](https://code.byted.org/nclc-platform/kunlun-builder/commit/cd4066357c457a361eb1e6286b2bb07f80a92089) | S      |        |
| 导出复合组件模型                 | ✅ 已完成 | Kunlun Builder, 复合组件 | [chore: 导出复合组件模型](https://code.byted.org/nclc-platform/kunlun-builder/commit/cc6f04b046cec49c4c0891236224f6cae5dab2cb) | S      |        |
| 视图模型获取模型                 | ✅ 已完成 | Kunlun Builder, 复合组件 | [feat: 视图模型获取模型](https://code.byted.org/nclc-platform/kunlun-builder/commit/048261ec46b6cb6ffcc908c49e481bd3f4f9c585) | XS     |        |
| 模型模块值导出                   | ✅ 已完成 | Kunlun Builder, 复合组件 | [feat: 模型模块值导出](https://code.byted.org/nclc-platform/kunlun-builder/commit/88b1c2b1e32fc5df08308dde51be12426077f1f0) | S      |        |
| 新增属性记录进模型               | ✅ 已完成 | Kunlun Builder, 复合组件 | [feat: 新增属性记录进模型](https://code.byted.org/nclc-platform/kunlun-builder/commit/b909b771f88d6737777a2c4dbbd486581374d830) | L      |        |
| i18n结构适配新版                 | ✅ 已完成 | Kunlun Builder, 复合组件 | [perf: i18n结构适配新版](https://code.byted.org/nclc-platform/kunlun-builder/commit/5073b4ecfd4875ec999d4a09683864695bd92823) | S      |        |
| 属性排序组件                     | ✅ 已完成 | Kunlun Builder, 复合组件 | [feat: 属性排序组件](https://code.byted.org/nclc-platform/kunlun-builder/commit/c5df3ad0d49aace1d4881e7009c8596d0b3675ff) | L      |        |
| 更新propSettings模型方法         | ✅ 已完成 | Kunlun Builder, 复合组件 | [feat: 更新propSettings模型方法](https://code.byted.org/nclc-platform/kunlun-builder/commit/d405603611c8b2efec1e6ec6857c8a313aac61f6) | M      |        |
| 组件模型属性列表接入视图模型     | ✅ 已完成 | Kunlun Builder, 复合组件 | [feat: 组件模型属性列表接入视图模型](https://code.byted.org/nclc-platform/kunlun-builder/commit/82d5491c5a72b49acde5a35becd52e52b90880e5) | M      |        |
| 重构连接器架构                   | ✅ 已完成 | Kunlun Builder, 复合组件 | [perf: 重构连接器架构](https://code.byted.org/nclc-platform/kunlun-builder/commit/24c866edd5edf1950e0b1288f659b41b5aaf0917) | M      |        |

### 明日计划

- 编辑组件属性功能
- 删除组件属性功能
- 组件模型接入值系统

---

## 3月17日

| 工作事项               | 进度     | 项目                         | 文档                                                         | 工作量 | 协作者 |
| ---------------------- | -------- | ---------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 获取页面运行时草稿数据 | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [feat: 获取页面运行时草稿数据](https://code.byted.org/nclc-platform/kunlun-builder/commit/92345867a0aa03dfa8fdf275fd528c2b0b8b979d) | S      |        |
| 属性设置输入输出面板   | ✅ 已完成 | Kunlun Builder, 复合组件     | [feat: 属性设置输入输出面板](https://code.byted.org/nclc-platform/kunlun-builder/commit/d0cc8efb7d20a5b9c604ffc32f135a796b9ec3fc) | L      |        |
| 抽离通用单选与描述组件 | ✅ 已完成 | Kunlun Builder, 复合组件     | [feat: 抽离通用单选与描述组件](https://code.byted.org/nclc-platform/kunlun-builder/commit/3b6861657081d8cb9b51088752fb3312c661e3b4) | M      |        |
| 添加自定义属性功能     | ✅ 已完成 | Kunlun Builder, 复合组件     | [feat: 添加自定义属性功能](https://code.byted.org/nclc-platform/kunlun-builder/commit/338a08c8eb606f3090a7f9f435630f2026c49298) | M      |        |
| 添加属性接入表单机制   | ✅ 已完成 | Kunlun Builder, 复合组件     | [feat: 添加属性接入表单机制](https://code.byted.org/nclc-platform/kunlun-builder/commit/a7e927880859f2a4f6d17f5ffa33c3c50130b839) | M      |        |

### 明日计划

- 复合组件属性面板

---

## 3月16日

| 工作事项                     | 进度         | 项目                         | 文档                                                         | 工作量 | 协作者 |
| ---------------------------- | ------------ | ---------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 设置面板增加按钮插件         | ⏰ 无限期推迟 | Kunlun Builder, 复合组件     |                                                              |        |        |
| 页面复制洗数据方案确认       | ✅ 已完成     | Kunlun Builder, 页面         |                                                              |        |        |
| 子页面导航请求懒加载方案确认 | ✅ 已完成     | Kunlun Builder, 子页面拆分   |                                                              |        |        |
| feature插件隐藏机制确认      | ✅ 已完成     | Kunlun Builder, 复合组件     |                                                              |        |        |
| 无权限横幅屏蔽优化           | ⏱ 推迟一天   | Kunlun Builder, 权限         |                                                              |        |        |
| 先切换为设计侧的草稿预览接口 | ✅ 已完成     | Kunlun Builder, 一体化编辑器 | [chore: 先切换为设计侧的草稿预览接口](https://code.byted.org/nclc-platform/kunlun-builder/commit/83e8f825803c8f284c28c89a6263894540e391b4) |        |        |
| 复合组件根节点组件           | ✅ 已完成     | Kunlun Builder, 复合组件     | [feat: 复合组件根节点组件](https://code.byted.org/nclc-platform/kunlun-builder/commit/87be79cea130b1f2e38e7ec20af92355856b32e0) |        |        |
| 属性设置面板弹层             | ✅ 已完成     | Kunlun Builder, 复合组件     | [feat: 属性设置面板弹层](https://code.byted.org/nclc-platform/kunlun-builder/commit/82de3a03278195fed5ec32d6d8614cffbb5d564d) |        |        |

### 笔记

- 页面复制
  -  和张帅对了下，之后页面列表复制功能会有熟悉kunlun-fe的同学来做。我负责kunlun-builder侧的修改。
  - 3.16-4.6方案设计
  - 4.7-4.14开发、联调、测试
  - 4.14上车
  - 4.14-4.20集成测试
  - 4.20上线

### 明日计划

- 无权限横幅屏蔽优化

---

## 3月15日

| 工作事项                   | 进度     | 项目                       | 文档                                                         | 工作量 | 协作者 |
| -------------------------- | -------- | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 复合组件模型服务基座       | ✅ 已完成 | Kunlun Builder, 复合组件   | [feat: 复合组件模型服务基座](https://code.byted.org/nclc-platform/kunlun-builder/commit/6c7845fc86393ff18f2d4e1e9670be6ee863e290) | M      |        |
| 增加导出类型提示           | ✅ 已完成 | Kunlun Builder, 复合组件   | [chore: 增加导出类型提示](https://code.byted.org/nclc-platform/kunlun-builder/commit/bea8b03136dfbb0dabfb32ba63414cd4dcb379bd) | S      |        |
| 增加模型连接器机制         | ✅ 已完成 | Kunlun Builder, 复合组件   | [feat: 增加模型连接器机制](https://code.byted.org/nclc-platform/kunlun-builder/commit/44aea268940d5859e00d62bd5ce6bc3448b78767) | M      |        |
| 只能通过连接器触发模型更改 | ✅ 已完成 | Kunlun Builder, 复合组件   | [feat: 只能通过连接器触发模型更改](https://code.byted.org/nclc-platform/kunlun-builder/commit/d8c500972bb37b82ec9277a6a95380099cb5fdf5) | M      |        |
| 同步子页面拆分进展         | ✅ 已完成 | Kunlun Builder, 子页面拆分 | [Builder 2.0子页面拆分进展](https://bytedance.feishu.cn/docx/MCrMdVmrzoxLQgx6tjFclxN4nWh) | S      | 李玉北 |

### 笔记

- [Builder 2.0子页面拆分进展](https://bytedance.feishu.cn/docx/MCrMdVmrzoxLQgx6tjFclxN4nWh) 

---

## 3月14日

| 工作事项                       | 进度       | 项目                         | 文档                                                         | 工作量 | 协作者 |
| ------------------------------ | ---------- | ---------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 修复沙箱预览提示宽度           | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [feat: 修复沙箱预览提示宽度](https://code.byted.org/nclc-platform/kunlun-builder/commit/83f9759f9a7aa2c32f5d78aefc409153b62d3cbe) | XS     |        |
| 确认跨页面复制i18n文案缺失问题 | ✅ 已完成   | Kunlun Builder, bindData治理 |                                                              |        |        |
| 页面复制方案确认               | ✅ 已完成   | Kunlun Builder, 页面         |                                                              |        |        |
| 开始开发复合组件               | ⏱ 推迟一天 | Kunlun Builder, 复合组件     |                                                              |        |        |

### 明日计划

- 开始开发复合组件

## 跟进

- 跨页面复制i18n文案缺失
- 无权限横幅提示屏蔽
- 引用组件属性值数据在i18n内，并且由于不带ID，不能被引用收集
  - ![img](https://bytedance.larkoffice.com/space/api/box/stream/download/asynccode/?code=NWVmMzk2MzQxNGNiNzBlMzI2NGRjZmE0OGMzODQ3OGZfR3VKcjQ3MmowNHVBWjk1cUdhbzJPNW1LZ0QycHRFUU9fVG9rZW46Ym94Y25EMUlJNVhyaWt4aTllVXZDZFlOTG1nXzE3MDAxMzM0OTk6MTcwMDEzNzA5OV9WNA)![img](https://bytedance.larkoffice.com/space/api/box/stream/download/asynccode/?code=NzA0OTI2MmUxMWE4YzhmODI1ZTkyOTljM2E2MjhkZTZfRVhVZDAwemNUbVQ2WThMbm1JVm16YTJydklZYWt5dVVfVG9rZW46Ym94Y25WSUlWMTZXbEpNZzZQR1FLa3NQeDhmXzE3MDAxMzM0OTk6MTcwMDEzNzA5OV9WNA)

---

## 3月13日（请病假😢）

---

## 3月10日

| 工作事项                     | 进度     | 项目                         | 文档                                                         | 工作量 | 协作者 |
| ---------------------------- | -------- | ---------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 完善bindData治理技术方案     | ✅ 已完成 | Kunlun Builder, bindData治理 | [bindData治理技术方案](https://bytedance.feishu.cn/docx/GVSndHPkXoSGUvxSsy6ct4j7nMb) | M      |        |
| 主持bindData治理技术方案评审 | ✅ 已完成 | Kunlun Builder, bindData治理 |                                                              | M      |        |

### 明日计划

- 开始开发复合组件

---

## 3月9日

| 工作事项                     | 进度     | 项目                         | 文档                                                         | 工作量 | 协作者 |
| ---------------------------- | -------- | ---------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 绩效 - 填写 360º             | ✅ 已完成 | Bytedance                    | https://people.bytedance.net/performance/perf/review/7197031867428716546/7197703287737548802/members?lang=zh-CN&open_in_browser=true | XL     |        |
| 修复预览页失效               | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [fix: 修复预览页失效](https://code.byted.org/nclc-platform/kunlun-builder/commit/ab765cdfc559e06a8b3083e32f75a76ee5592599) | XS     | 周伟濠 |
| 草稿预览接口环境更改为运行时 | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [feat: 草稿预览接口环境更改为运行时](https://code.byted.org/nclc-platform/kunlun-builder/commit/afc9a7d4a47f7d27a63587d1f083ca5851923d06) | S      |        |
| 提交后刷新草稿预览页         | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [feat: 提交后刷新草稿预览页](https://code.byted.org/nclc-platform/kunlun-builder/commit/2245256379911bfc73a44051b4dc6a00257ca52f) | XS     |        |

### 明日计划

- 完善bindData治理技术方案
- bindData治理技术方案评审

---

## 3月8日

| 工作事项                             | 进度         | 项目                         | 文档                                                         | 工作量 | 协作者 |
| ------------------------------------ | ------------ | ---------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 修复一体化环境判断                   | ✅ 已完成     | Kunlun Builder, 一体化编辑器 | [fix: 修复一体化环境判断](https://code.byted.org/nclc-platform/kunlun-builder/commit/ef1de251f13a0d8228dbdc8ab5de84ccaaddedd3) | XS     |        |
| 不处于一体化时增加顶部栏高度         | ✅ 已完成     | Kunlun Builder, 一体化编辑器 | [perf: 不处于一体化时增加顶部栏高度](https://code.byted.org/nclc-platform/kunlun-builder/commit/0272716841e95aaac344d4b4ae97fb694f0d23c3) | XS     |        |
| 修复按钮高度                         | ✅ 已完成     | Kunlun Builder, 一体化编辑器 | [fix: 修复按钮高度](https://code.byted.org/nclc-platform/kunlun-builder/commit/aabb12df831976d36d396431fe18f4dd95d68332) | XS     |        |
| 下拉选择Runtime下拉内部 padding错误  | ✅ 已完成     | Kunlun Builder, 一体化编辑器 | [fix: 下拉选择Runtime下拉内部 padding错误](https://code.byted.org/nclc-platform/kunlun-builder/commit/13d7094350f2a818f8fdd76f5c7dd2ec4bd351e8?merge_request_iid=3513) | XS     |        |
| 修复下拉选择全局选项选择文字大小12px | ✅ 已完成     | Kunlun Builder, 一体化编辑器 | [fix: 修复下拉选择全局选项选择文字大小12px](https://code.byted.org/nclc-platform/kunlun-builder/commit/2be4abf542dcdc900e185495af617a1f4817a546?merge_request_iid=3513) | XS     |        |
| 草稿预览运行时接口                   | ⏱ 推迟一天   | Kunlun Builder, 一体化编辑器 |                                                              |        |        |
| 绩效 - 填写 360º                     | 📈 连续到明天 | Bytedance                    | https://people.bytedance.net/performance/perf/review/7197031867428716546/7197703287737548802/members?lang=zh-CN&open_in_browser=true | XL     |        |
| 绩效 - 自评                          | ✅ 已完成     | Bytedance                    | https://people.bytedance.net/performance/perf/review/7197031867428716546/7197703287737532418/preview?lang=zh-CN&open_in_browser=true | M      |        |

### 明日计划

- 草稿预览接口环境更改为运行时
- bind技术方案文档
- bind提测时间
- 绩效 - 填写 360º 

---

## 3月7日

| 工作事项                                   | 进度       | 项目                         | 文档                                                         | 工作量 | 协作者      |
| ------------------------------------------ | ---------- | ---------------------------- | ------------------------------------------------------------ | ------ | ----------- |
| 子页面拆分性能验证：搭建一个足够复杂的应用 | ✅ 已完成   | Kunlun Builder, 子页面拆分   |                                                              | M      |             |
| 浏览器空闲时加载                           | ✅ 已完成   | Kunlun Builder, 子页面拆分   | [perf: 浏览器空闲时加载](https://code.byted.org/nclc-platform/kunlun-builder/commit/81734bc6416f5fc02bf10996b2b5e7e30165d7e1) |        |             |
| UIDL拆分技术验证（快速演示）               | ✅ 已完成   | Kunlun Builder, 子页面拆分   |                                                              |        | Hugo,李玉北 |
| bindData技术方案                           | ⏱ 推迟一天 | Kunlun Builder, bindData治理 |                                                              |        |             |
| 适配自适应弹窗高度                         | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [fix: 适配自适应弹窗高度](https://code.byted.org/nclc-platform/kunlun-builder/commit/7e6cef7bfc32db75e28986af8587b4403c6c0153) | M      |             |
| 弹层阴影去除上边框覆盖                     | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [fix: 弹层阴影去除上边框覆盖](https://code.byted.org/nclc-platform/kunlun-builder/commit/325c6c1488382f335c999d0f721e26ab0596fe95) | XS     |             |
| 修复翻译图标i18n文案                       | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [fix: 修复翻译图标i18n文案](https://code.byted.org/nclc-platform/kunlun-builder/commit/b0d6ae927d12d73fe55e127337e5e95c9f302381) | S      |             |
| 绩效 - 填写 360º                           | ⏱ 推迟一天 | Bytedance                    |                                                              |        |             |
| 绩效 - 自评                                | ⏱ 推迟一天 | Bytedance                    |                                                              |        |             |

---

## 3月6日

| 工作事项                                   | 进度         | 项目                         | 文档                                                         | 工作量 | 协作者 |
| ------------------------------------------ | ------------ | ---------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 子页面拆分保存接入统一保存                 | ⏰ 无限期推迟 | Kunlun Builder, 子页面拆分   |                                                              |        |        |
| 子页面拆分性能验证：搭建一个足够复杂的应用 | ⏱ 推迟一天   | Kunlun Builder, 子页面拆分   |                                                              |        |        |
| 子页面拆分拉会                             | ✅ 已完成     | Kunlun Builder, 子页面拆分   |                                                              |        |        |
| bindData问题确认                           | ✅ 已完成     | Kunlun Builder, bindData治理 | [bindData问题确认](https://bytedance.feishu.cn/docx/PBVrdFZWJoB0BsxsNTLcDJgMnNb) |        |        |
| 子页面拆分技术验证方案                     | ✅ 已完成     | Kunlun Builder, 子页面拆分   | [子页面拆分技术验证方案](https://bytedance.feishu.cn/docx/BLnUdtt6OoVnIPxprkcc8HPRnrn) |        |        |

### 笔记

- [bindData问题确认](https://bytedance.feishu.cn/docx/PBVrdFZWJoB0BsxsNTLcDJgMnNb) 
- [子页面拆分技术验证方案](https://bytedance.feishu.cn/docx/BLnUdtt6OoVnIPxprkcc8HPRnrn) 

### 明日计划

- bindData技术方案
- 子页面拆分Demo演示

---

## 3月4日（加班😩）

| 工作事项                             | 进度       | 项目                       | 文档                                                         | 工作量 | 协作者 |
| ------------------------------------ | ---------- | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 修复当前节点出现两次的问题           | ✅ 已完成   | Kunlun Builder, 子页面拆分 | [fix: 修复当前节点出现两次的问题](https://code.byted.org/nclc-platform/kunlun-builder/commit/485c0f12539d4e9c2842e3c3bb9d2e8394fe7a95) | S      |        |
| uidl子页面重组算法                   | ✅ 已完成   | Kunlun Builder, 子页面拆分 | [feat: uidl子页面重组算法](https://code.byted.org/nclc-platform/kunlun-builder/commit/8afdef931735ca7cce7ca248971cb48b2afdb865) | M      |        |
| 修复传入导航ID导致无法查找到子页问题 | ✅ 已完成   | Kunlun Builder, 子页面拆分 | [fix: 修复传入导航ID导致无法查找到子页问题](https://code.byted.org/nclc-platform/kunlun-builder/commit/7d4ebb4fd01ddbf014d26304f462aec631886cd5) | S      |        |
| 丰富子页面片段请求返回值信息         | ✅ 已完成   | Kunlun Builder, 子页面拆分 | [feat: 丰富子页面片段请求返回值信息](https://code.byted.org/nclc-platform/kunlun-builder/commit/9a756a85baf7193140bd7878c66f66a58178c0cc) | M      |        |
| 返回UIDL片段时拼接子节点             | ✅ 已完成   | Kunlun Builder, 子页面拆分 | [feat: 返回UIDL片段时拼接子节点](https://code.byted.org/nclc-platform/kunlun-builder/commit/87152b204e9330e02450111685e36d3c9ed9a117) | L      |        |
| UIDL处理函数                         | ✅ 已完成   | Kunlun Builder, 子页面拆分 | [feat: UIDL处理函数](https://code.byted.org/nclc-platform/kunlun-builder/commit/0f23905a6db08df31dcf7d01c25779add015196e) | S      |        |
| 子导航页自动加载自身片段             | ✅ 已完成   | Kunlun Builder, 子页面拆分 | [feat: 子导航页自动加载自身片段](https://code.byted.org/nclc-platform/kunlun-builder/commit/5a9c951d8bebbd19d550722ed7794419394ccfc8) | M      |        |
| 修复设计器引用运行时内容报错         | ✅ 已完成   | Kunlun Builder, 子页面拆分 | [fix: 修复设计器引用运行时内容报错](https://code.byted.org/nclc-platform/kunlun-builder/commit/10081336fe4ceb48d04d4fab8f0f059577b4d473) | S      |        |
| 接入localhost后端                    | ✅ 已完成   | Kunlun Builder, 子页面拆分 |                                                              | S      | 李有为 |
| 子页面拆分保存接入统一保存           | ⏱ 推迟一天 | Kunlun Builder, 子页面拆分 |                                                              |        |        |

### 明日计划

- 子页面拆分保存接入统一保存

---

## 3月3日

| 工作事项                         | 进度     | 项目                         | 文档                                                         | 工作量 | 协作者 |
| -------------------------------- | -------- | ---------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 获取目标子页面所在前序路径       | ✅ 已完成 | Kunlun Builder, 子页面拆分   | [feat: 获取目标子页面所在前序路径](https://code.byted.org/nclc-platform/kunlun-builder/commit/b3fa27768d29f68e411018d07661b1dfc4ff4a57) | M      |        |
| 调试模式下加入一体化外壳         | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [feat: 调试模式下加入一体化外壳](https://code.byted.org/nclc-platform/kunlun-builder/commit/e3592b825f79a24507d4a256c86315213aadebfe) | S      |        |
| 顶部工具栏宽度缩小错误折叠       | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [fix: 顶部工具栏宽度缩小错误折叠](https://code.byted.org/nclc-platform/kunlun-builder/commit/acd1b0101518d5544d08795e926d1bf724547d34) | XS     |        |
| 弹层侧拉窗定位适配一体化外壳     | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [perf: 弹层侧拉窗定位适配一体化外壳](https://code.byted.org/nclc-platform/kunlun-builder/commit/586230f6e27b4370f8593abfa585f123c41d3e24) | XS     |        |
| 路径/ns生成规则改为/pc           | ✅ 已完成 | Kunlun Builder, 一体化编辑器 | [fix: 路径/ns生成规则改为/pc](https://code.byted.org/nclc-platform/kunlun-builder/commit/6941942e332eeef4483c9c10773d8f7a3e72f73a) | XS     |        |
| 草稿预览插件国际化问题           | ✅ 已完成 | Kunlun Builder, 一体化编辑器 |                                                              | S      | 孙浩维 |
| 绩效 - 填写重点工作产出          | ✅ 已完成 | Bytedance                    | https://people.bytedance.net/performance/perf/review/7197031867428716546/7197703287737911958/preview?lang=zh-CN&open_in_browser=true | M      |        |
| 绩效 - 邀请 360º 评估人          | ✅ 已完成 | Bytedance                    | https://people.bytedance.net/performance/perf/review/7197031867428716546/7197703287737499650/preview | XS     |        |
| Builder 2.0子页面拆分进展（3.3） | ✅ 已完成 | Kunlun Builder, 子页面拆分   | [Builder 2.0子页面拆分进展（3.3）](https://bytedance.feishu.cn/docx/MCrMdVmrzoxLQgx6tjFclxN4nWh) | S      |        |

### 笔记

- [Builder 2.0子页面拆分进展（3.3）](https://bytedance.feishu.cn/docx/MCrMdVmrzoxLQgx6tjFclxN4nWh) 

- 绩效 - 重点工作产出

  - 重点工作产出 1 Kunlun底层能力（9月-3月） 1. Builder权限系统Owner，负责接入Kunlun页面权限、流程权限、对象与数据集权限，权限服务架构设计，视图侧权限服务接入。 1.1 流程权限系统2.0 ，接入Kunlun新版流程权限，全面重构权限收集系统，权限视图层接入系统，耗时一周完成重构，并实现BUG Free。 1.2 流程权限系统1.0，接入Kunlun旧版流程权限，设计视图侧接入鉴权最小侵入方式。 - 流程权限运行数据流 https://bytedance.feishu.cn/docx/CpRldSRkooRjcKxQV4QcY5BInse - 权限维护风险文档 https://bytedance.feishu.cn/docx/Rc6ydXForo3LT2x7u0yc6Gh7nUg 1.3 页面权限系统，页面树生成算法，无权限页裁剪算法，导航最短路径定位算法，设计并实施导航唯一ID改造。 1.4 对象权限接入，调研对象、数据集、字段、记录的鉴权方式，并设计2.0的无权限表现方式与无权限状态扩散范围，相比1.0方案更合理。 - 权限相关的数据展示UI组件调研 https://bytedance.feishu.cn/wiki/wikcn6Ujo7sfn5GUiEJFp928QUb 2. 引用收集Owner，由于2.0初始开发阶段没有考虑引用收集，在接手这一需求Gap时快速了解上下文，并设计出五种可行的技术方案，从中挑选出两种技术方案 1. 成本最低的ID收集方案用于之前开发遗留数据的收集，最快速补齐Gap 2. 兼容性/健壮性最佳的Type标记方案用于面向未来的数据收集。两种方案都已在Kunlun Builder中实装，Type标记方案已支持飞书聊天、飞书集成、HTML组件、自定义组件的引用收集需求。 - 元数据引用方式技术方案 https://bytedance.feishu.cn/docx/UfnmdKm4Goimnax8PUiceBU8nqb - 元数据引用方式ID收集方案 https://bytedance.feishu.cn/wiki/wikcn0jSzOogwBjNqftunAt49Sd - 元数据引用方式实施方案 https://bytedance.feishu.cn/docx/LyjqdIUHjoRdtLxuWEQcEHGAnWc - 引用收集五种方案思路 https://bytedance.feishu.cn/docx/IYXSdS4gOoH91vx1tHzcdWNhnsL 3. 元数据 API Name 转 ID 映射，负责方案设计，接口设计，接口联调，开发工作。 - 元数据 API Name 转 ID 映射关系前端接入 https://bytedance.feishu.cn/docx/PcEldpMuXovmKexzDucc1RadnMe 4. 自动保存服务，设计自动保存服务技术方案，接入设计器、组件属性配置、页面变量、页面配置、国际化面板等五个模块，并推进8个保存接口合并为1个接口，针对草稿预览做了性能优化，最大程度保证不影响Builder性能。 - 一体化编辑器技术文档（Builder部分文档）https://bytedance.feishu.cn/docx/THQUdsFRioh7K2xuuXycDhrwnZe 5. 身份模拟功能 6. 生命周期服务与回调钩子设计与开发

    重点工作产出 2 Kunlun组件物料（8月-9月） 1. 组件开发：产出并维护富文本组件，宫格项，下拉选择三个组件，以及对应Setter。 https://bytedance.feishu.cn/docx/doxcndIxzDOVUyY9Gbim91m5vMU https://bytedance.feishu.cn/docx/DdWDdPDVwoVEy9xYXijcnFSvnlg 2. Setter开发：支持矩阵表字段选择Setter这一Kunlun最复杂setter的开发，在UIPaaS物料仓库中支持LogoSetter的开发。 3. Builder2.0组件开发规范中类型系统调研与设计，状态系统设计 - 组件化思想与Builder组件 https://bytedance.feishu.cn/docx/M8Lmd8l1morNRTxGm40cUaxQntf - TS类型信息与Kunlun运行时类型信息结构对比 https://bytedance.feishu.cn/docx/LAowdEfnlocukdx0CBYc7BYHnph 4. 参与复合组件技术方案方案产出，复合组件版本管理方案。 - 复合组件版本方案思考 https://bytedance.feishu.cn/wiki/wikcnYPYREshUWDuMqG4QM258Kf - 复合组件能力缺失 https://bytedance.feishu.cn/wiki/wikcnge5WrIEbrjRC5uVgT7ZbOf - 复合组件开发规划（一期 12.26~1.16） https://bytedance.feishu.cn/docx/CDQedQOdbobaB4x2PB5c2BMEnTF - 梳理组件区块问题点 https://bytedance.feishu.cn/docx/YydGdRx8SohcDpxwIswcNjlcnJM - 复合组件开发步骤拆解 https://bytedance.feishu.cn/docx/Y58pdXRgsoO3P8xsJ4acjK7PnYb - 复合组件生产各模块问题整理 https://bytedance.feishu.cn/docx/PAU5dLStToBACpx3nXDc1amFnKb 5. 一体化编辑器，顶部工具栏适配，草稿预览功能。 - 一体化编辑器技术文档（Builder部分文档） https://bytedance.feishu.cn/docx/THQUdsFRioh7K2xuuXycDhrwnZe - 预览问题技术解决方案 https://bytedance.feishu.cn/docx/KtAjduXpVoO0bsxT0jocRxrInbh 6. 支持富文本组件，宫格项，下拉选择的UIDL To UIMeta转换脚本，增加ID引用解析。 - UIMeta 增加 ID 引用 https://bytedance.feishu.cn/docx/MilGdvcFhotMS8xMqxGcn1I1nVg 7. 自定义组件兼容，自定义组件UIMeta转UIDL。 - 电商自定义组件梳理 https://bytedance.feishu.cn/wiki/wikcnjFm7PFlnACPVS1Ya8PtYBd - 自定义组件UIMeta与UIDL结构对比 https://bytedance.feishu.cn/docx/I8zKdOqbkohfYlxIh23czaRDnhh - 自定义组件开发规范问题点思考 https://bytedance.feishu.cn/docx/QLakdv4Xmostv0xD0kCc7trPnqh

    重点工作产出 3 在UIPaaS Tech 建设（7月-8月） 入口：https://open.feishu.cn/builder/apps 站点使用文档：https://bytedance.feishu.cn/docx/TxwtdO2DGoftdkxbDtbc6rLOnTh 1. 独立完成 Node 服务端研发，完成框架搭建、网关接入、数据分层、服务隔离、性能优化等服务端开发工作。 2. 设计研发权限系统，支持权限角色对数据操作限制粒度，并对所有数据接口接入角色鉴权服务。 架构设计图：[https://www.figma.com/file/35kWgaYvB1JbmygJQs2LPs/aPaaS-Builder-%E6%9D%83%E9%99%90%E7%B3%BB%E7%BB%9F?t=3eSGTYtKkjqLyCq9-1](https://www.figma.com/file/35kWgaYvB1JbmygJQs2LPs/aPaaS-Builder-权限系统?t=3eSGTYtKkjqLyCq9-1) 3. 设计研发 BuilderService，对每个Builder实体进行单独管理，单独发布，单独下载。 架构设计图：[https://www.figma.com/file/677nHISrpN5nc4BTKzH85g/aPaaS-Builder-%E7%BB%93%E6%9E%84?t=3eSGTYtKkjqLyCq9-1](https://www.figma.com/file/677nHISrpN5nc4BTKzH85g/aPaaS-Builder-结构?t=3eSGTYtKkjqLyCq9-1) 4. 研发实现了版本管理、插件管理、接入飞书登录、实现源码下载等多个重要功能 5. 在不到一个半月的时间内就完成了整个站点从0到1的建设，使得用户可以个性化体验我们的搭建系统、快速研发插件和业务接入，大大降低了接入成本。

### 明日计划

- 子页面重组算法
- 返回UIDL片段时拼接子节点

---

## 3月2日

| 工作事项               | 进度     | 项目                       | 文档                                                         | 工作量 | 协作者 |
| ---------------------- | -------- | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 子页面拆分面临问题对齐 | ✅ 已完成 | Kunlun Builder, 子页面拆分 | [子页面拆分面临问题](https://bytedance.feishu.cn/docx/XAY8dzRDXoBhUMxpM0FcRK0Unsc) | M      | Hugo   |
| 子页面切片算法         | ✅ 已完成 | Kunlun Builder, 子页面拆分 | [feat: 子页面切片算法](https://code.byted.org/nclc-platform/kunlun-builder/commit/4f29c34fdae85aaded1e0a5d4bd22403831ffad1) |        |        |

### 笔记

- [子页面拆分面临问题](https://bytedance.feishu.cn/docx/XAY8dzRDXoBhUMxpM0FcRK0Unsc) 

### 明日计划

- 获取目标子页面所在前序路径

---

## 3月1日

| 工作事项                       | 进度       | 项目                         | 文档                                                         | 工作量 | 协作者 |
| ------------------------------ | ---------- | ---------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 自动保存性能优化               | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [perf: 自动保存性能优化](https://code.byted.org/nclc-platform/kunlun-builder/commit/f84bf840ece1bb577c30c3af0dcea509bb582ff2) | S      |        |
| 草稿态预览插件自动加载性能优化 | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [perf: 草稿态预览插件自动加载性能优化](https://code.byted.org/nclc-platform/kunlun-builder/commit/ad3161613fa7bb36a9d28116d57dca8dcc9e62b4) | S      |        |
| 草稿态预览插件刷新与退出功能   | ✅ 已完成   | Kunlun Builder, 一体化编辑器 | [feat: 草稿态预览插件刷新与退出功能](https://code.byted.org/nclc-platform/kunlun-builder/commit/97b9837e6f52330155c6b3464360e03c72fb5f10) | M      |        |
| 顶部工具栏对照设计稿           | ⏱ 推迟一天 | Kunlun Builder, 一体化编辑器 |                                                              |        |        |
| 绩效 - 填写重点工作产出        | ⏱ 推迟一天 | Bytedance                    |                                                              |        |        |
| 绩效 - 邀请 360º 评估人        | ⏱ 推迟一天 | Bytedance                    |                                                              |        |        |

### 明日计划

- 确认子页面拆分方案