## 项目跟进

- 「🛏 未开始」支持有引用记录的应用生成安装包链接
  - [【PRD】应用增长 - 支持有引用记录的应用生成安装包链接 - 第 1 次议会评审](https://bytedance.feishu.cn/docx/doxcnxHruxtWqdMSWyPUy5be5Th) 
  - [技术方案 - Builder 支持引用记录的链接安装](https://bytedance.feishu.cn/docx/NdRmdjtbHov8dHxUcZfcbSwQnsh) 
  - [场景梳理 - UI 支持引用记录的链接安装](https://bytedance.feishu.cn/docx/LaKIdxlneo8fPjxEiPpcp9FYnfe) 
  - 依赖项
    - 设计态错误检查
    - 组件属性定位功能
- 「🛠 进行中」子页面拆分
  - https://meego.feishu.cn/apaas_/story/detail/11922765#comment
  - [子页面拆分面临问题](https://bytedance.feishu.cn/docx/XAY8dzRDXoBhUMxpM0FcRK0Unsc) 
  - [Builder 2.0子页面拆分进展（3.3）](https://bytedance.feishu.cn/docx/MCrMdVmrzoxLQgx6tjFclxN4nWh) 
- 「🛠 进行中」前端API ID治理专项
  - [APIID统一生成规则方案](https://bytedance.feishu.cn/docx/Y4fBd8kwFotbJRx7m7VcZiK7nvf?chatTab=1&useIframe=1&multiPage=1) 
  - [前端模块划分及Builder1.0下线时间对齐](https://bytedance.feishu.cn/docx/WTEcdztrNoEnMVxwKHEcQGapnJd) 
  - [aPaaS APIID治理专项Kickoff](https://bytedance.feishu.cn/docx/ZaL6dWtnxoUg1KxlIYQcQrh7nYw) 
  - [URL 规范改造影响范围](https://bytedance.feishu.cn/docx/RPe1d2XXYoiKbmxKDrsc3cWungb) 
  - [ID 、API ID、API Name 现状问题 case 分析](https://bytedance.feishu.cn/docx/Dr6odwWfroJCM2xmxQWcA1SRnzd) 
- 「🖇️ 已交接」页面复制
  - https://meego.feishu.cn/apaas_/story/detail/9999659
- 「🖇️ 已交接」自定义组件兼容
- 「🖇️ 已交接」流量朔源
  - [[aPaaS.技术方案\] 流量溯源](https://bytedance.feishu.cn/docx/UkHddQoJFo1eXuxGiZ9cc3m8nqe?chatTab=1&useIframe=1&multiPage=1) 
- 「🖇️ 已交接」2.0支持第三方鉴权
  - https://meego.feishu.cn/apaas_/story/detail/9244041?parentUrl=%2Fworkbench#comment
  - [[权限\][技术方案]Permission支持三方鉴权](https://bytedance.feishu.cn/wiki/wikcngYd6Z94pmUqepxGTh2E74e) 
  - [【技术方案】「支持三方鉴权」FE](https://bytedance.feishu.cn/wiki/wikcnPndBrwIAIIOgi6McAdcVkf) 
- 「✅已完成」bindData治理
  - https://meego.feishu.cn/apaas_/story/detail/9818870
  - [bindData问题确认](https://bytedance.feishu.cn/wiki/wikcnrlJBVeuCkbWQhRBt28BRvY?from=space_personal_filelist&pre_pathname=%2Fdrive%2Ffolder%2FfldcnUCfu8c1Ck51vP2cC0vB4db) 
  - [bindData治理技术方案](https://bytedance.feishu.cn/docx/GVSndHPkXoSGUvxSsy6ct4j7nMb) 
- 「✅已完成」无代码搭建复合组件
  - https://meego.feishu.cn/apaas_/story/detail/7035300
  - [【Builder 2.0】可重复使用的复合组件 - 宣讲版](https://bytedance.feishu.cn/docx/UNG2dTzfGo6YIuxyAjfc87bnn4f) 
  - [Figma-复合组件设计稿](https://www.figma.com/file/WeQidAuav41EnfReTIyB1Y/branch/NRP6Oz1OV99mjlDqxuPbi5/Web?node-id=10830-222118&t=NZql8M2MNDzPCi2E-0)
  - [复合组件一期需求研发节奏](https://bytedance.feishu.cn/wiki/wikcnKLJCMEIf4JjaEFr8MaMJrc?chatTab=1&useIframe=1&multiPage=1) 
  - [UX拆解](https://bytedance.feishu.cn/wiki/wikcnN2ZC3iEJLpxtdp4hozDvhe?chatTab=1&useIframe=1&multiPage=1) 

---

## 4月28日

| 工作事项                             | 进度     | 项目                       | 文档                                                         | 工作量 | 协作者 |
| ------------------------------------ | -------- | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| uidl遍历支持element节点数组          | ✅ 已完成 | Kunlun Builder, 子页面拆分 | [chore: uidl遍历支持element节点数组](https://code.byted.org/nclc-platform/kunlun-builder/commit/795bd8d893d41169014a94f6b896952513835207) | S      |        |
| uidl拆分获取模版片段并插入目标子片段 | ✅ 已完成 | Kunlun Builder, 子页面拆分 | [feat: uidl拆分获取模版片段并插入目标子片段](https://code.byted.org/nclc-platform/kunlun-builder/commit/20b9e4dbfef88c4c5fa3094af088897a6088bf3d) | M      |        |
| uidl拆分支持片段拼接                 | ✅ 已完成 | Kunlun Builder, 子页面拆分 | [feat: uidl拆分支持片段拼接](https://code.byted.org/nclc-platform/kunlun-builder/commit/048658db7ed57cefce954247be463e1dddeaf3c7) | M      |        |
| uidl拆分服务增加jsdoc注释            | ✅ 已完成 | Kunlun Builder, 子页面拆分 | [docs: uidl拆分服务增加jsdoc注释](https://code.byted.org/nclc-platform/kunlun-builder/commit/05f805109b8e244ae7d2a2e243663615252c2d2e) | S      |        |

### 笔记

- automation的流程鉴权接口返回的数据没有过滤多值记录传参为空的情况
  -  解决方式是：在Builder调用接口前过滤掉所有记录流程鉴权中记录为空的流程参数

### 明日计划

- 类型推导算法

---

## 4月27日

| 工作事项                                 | 进度       | 项目                       | 文档                                                         | 工作量 | 协作者 |
| ---------------------------------------- | ---------- | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 阅读Lark FG 平台灰度功能开关接入使用文档 | ⏱ 推迟一天 | Kunlun Builder, 子页面拆分 | [Lark FG 平台灰度功能开关接入使用文档](https://bytedance.feishu.cn/docx/TUfSdnkWdoYLy2x8CYSc2BGXnKd) |        |        |
| uidl存储初始化逻辑                       | ✅ 已完成   | Kunlun Builder, 子页面拆分 | [feat: uidl存储初始化逻辑](https://code.byted.org/nclc-platform/kunlun-builder/commit/301af75dca96c3c34a88e69fe00e47bbbdfee498) | M      |        |
| uidl存储片段缓存                         | ✅ 已完成   | Kunlun Builder, 子页面拆分 | [feat: uidl存储片段缓存](https://code.byted.org/nclc-platform/kunlun-builder/commit/9b5aff353267530f4130f98b741944401606b608) | S      |        |
| uidl缓存完善UIDL节点映射信息             | ✅ 已完成   | Kunlun Builder, 子页面拆分 | [feat: uidl缓存完善UIDL节点映射信息](https://code.byted.org/nclc-platform/kunlun-builder/commit/468e723efc7aad3f4f663560c20666f1d5ef1add) | M      |        |
| uidl缓存增加jsdoc与注释                  | ✅ 已完成   | Kunlun Builder, 子页面拆分 | [feat: uidl缓存增加jsdoc与注释](https://code.byted.org/nclc-platform/kunlun-builder/commit/7d4c217fb28cbf5303804826c682862b69bee646) | M      |        |
| 新增获取节点ID所在前序路径               | ✅ 已完成   | Kunlun Builder, 子页面拆分 | [feat: 新增获取节点ID所在前序路径](https://code.byted.org/nclc-platform/kunlun-builder/commit/f24071be07025e6f78e285fcc2423dcb5203402a) | M      |        |
| uidl完整链路拼接与报错信息完善           | ✅ 已完成   | Kunlun Builder, 子页面拆分 | [feat: uidl完整链路拼接与报错信息完善](https://code.byted.org/nclc-platform/kunlun-builder/commit/b6b1aa3737a1694d75ac30feaf583d574f2ad5d6) | M      |        |

### 明日计划

- uidl片段拼接算法

---

## 4月26日

| 工作事项                                    | 进度       | 项目                       | 文档                                                         | 工作量 | 协作者 |
| ------------------------------------------- | ---------- | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 字段消费位置感知概要设计在Builder的改造方案 | ✅ 已完成   | Kunlun Builder, 元数据引用 | [【Draft】字段消费位置感知概要设计在Builder的改造问题对齐](https://bytedance.feishu.cn/docx/KlNfduDD7oErxlx77BAc2Cganwf) | L      |        |
| 尝试复刻1.0流程鉴权请求中对action的过滤     | ⏱ 推迟一天 | Kunlun Builder, 权限       |                                                              |        |        |
| 主持运行时UIDL拆分评审                      | ✅ 已完成   | Kunlun Builder, 子页面拆分 | [运行时 UIDL 拆分技术方案评审](https://bytedance.feishu.cn/wiki/W3Ddw0gX0iEuuSkjMcqcVSLwnQf) | L      |        |
| 修复身份模拟工具高度被覆盖                  | ✅ 已完成   | Kunlun Builder, 身份模拟   | [fix: 修复身份模拟工具高度被覆盖](https://code.byted.org/nclc-platform/kunlun-builder/commit/c9017857d6e8cf29234a647f3aec538c2f6053a4) | XS     |        |

### 笔记

- UIDL 拆分评审暴露出来一个问题：现在导航是一个组件，需要依赖 `elementType` 去做拆分，太特化了

### 明日计划

- UIDL 拆分开发

---

## 4月25日

| 工作事项                                      | 进度     | 项目                       | 文档                                                         | 工作量 | 协作者 |
| --------------------------------------------- | -------- | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 修复线上环境下拉选择展示新建测试数据按钮      | ✅ 已完成 | Kunlun Builder, 下拉选择   | [fix: 修复线上环境下拉选择展示新建测试数据按钮](https://code.byted.org/nclc-platform/kunlun-builder/commit/6c6626d75e1438e26e9349dfb344e71d5706c821) | S      |        |
| 页面初始化时默认没有webkit-font-smoothing属性 | ✅ 已完成 | Kunlun Builder, 身份模拟   | [fix: 页面初始化时默认没有webkit-font-smoothing属性](https://code.byted.org/nclc-platform/kunlun-builder/commit/aa5e2f3bddec076d87cbd7569ac47514353607a7) | S      |        |
| 字段消费位置感知概要设计在Builder的风险同步   | ✅ 已完成 | Kunlun Builder, 元数据引用 |                                                              |        |        |
| uidl拆分服务接口类型                          | ✅ 已完成 | Kunlun Builder, 子页面拆分 | [feat: uidl拆分服务接口类型](https://code.byted.org/nclc-platform/kunlun-builder/commit/7b915192a8ae185543f0f18e08eb8b19f7023b1d) | M      |        |
| uidl存储服务基础                              | ✅ 已完成 | Kunlun Builder, 子页面拆分 | [feat: uidl存储服务](https://code.byted.org/nclc-platform/kunlun-builder/commit/0cc7ff118b29a31a5ecaea124cd20b4ef0d7ffcd) | M      |        |
| uidl拆分服务基础                              | ✅ 已完成 | Kunlun Builder, 子页面拆分 | [feat: uidl拆分服务基础](https://code.byted.org/nclc-platform/kunlun-builder/commit/14d3d93573091cde44926e81160fd58c4189cb98) | M      |        |
| uidl拆分服务初始化接入基座                    | ✅ 已完成 | Kunlun Builder, 子页面拆分 | [feat: uidl拆分服务初始化接入基座](https://code.byted.org/nclc-platform/kunlun-builder/commit/644e9ae55480a2225382942359f1500574c82795) | S      |        |

### 笔记

- 字段消费位置感知概要设计在Builder的风险[字段消费位置感知概要设计](https://bytedance.feishu.cn/docx/ZxC9dWpqTo6jYaxSEHKcS0JSnzh) 
  - Builder2.0
    - 目前`Condition`，`Formula`，`ByteFX`不在PageConf.DomainModel.Reference（因为这俩不算元数据，收集上来没有消费场景，但现在加一下成本不高）
    - 这个需求需要定位到具体属性，变量面板，甚至激活Setter展示（Q2咱们只做到组件维度，这种定位到组件属性甚至激活出Setter面板的，需要整体设计一下）
  - Builder1.0
    - 能做到定位吗？我很担心没人能支持得动

### 明日计划

- 尝试复刻1.0流程鉴权请求中对action的过滤
- 字段消费位置感知概要设计在Builder的改造方案

---

## 4月24日

| 工作事项                                    | 进度     | 项目                       | 文档                                                         | 工作量 | 协作者 |
| ------------------------------------------- | -------- | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 完成编写【WIP】运行时 UIDL 拆分技术方案评审 | ✅ 已完成 | Kunlun Builder, 子页面拆分 | [【WIP】运行时 UIDL 拆分技术方案评审](https://bytedance.feishu.cn/docx/CgfFdaRODoisvkxWwVScQhNYnif) | XL     |        |
| 初始化类型推导Demo仓库                      | ✅ 已完成 | Kunlun Builder, 类型系统   | [init: initialize repo with engineered](https://code.byted.org/demo/adt-checker/commit/7c2aa833fb694a42890d15812178c000608a8dfa) | M      |        |
| ADT基础类型定义                             | ✅ 已完成 | Kunlun Builder, 类型系统   | [feat: basic adt type declare](https://code.byted.org/demo/adt-checker/commit/7264f36b8be1c630427484b137722f3206335ffc) | L      |        |

### 笔记

- 页面中有太多DOM节点会导致chrome渲染卡顿
- [【WIP】运行时 UIDL 拆分技术方案评审](https://bytedance.feishu.cn/docx/CgfFdaRODoisvkxWwVScQhNYnif) 

### 明日计划

- 走一遍评审流程[新 aPaaS TechReview（技术方案评审）流程操作指引](https://bytedance.feishu.cn/docx/N2ukdBnagovyXrxApOlcSxtHnfe) 
- 对接[【Apaas-Api-Utils】前端接口层标准化技术方案](https://bytedance.feishu.cn/docx/IuLHdNbWco4d1rxqij1cDkqCndh) 
- 生成前序路径索引的两种方案都列一下

---

## 4月23日

| 工作事项                                | 进度         | 项目                       | 文档                                                         | 工作量 | 协作者 |
| --------------------------------------- | ------------ | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 在Monorepo跑通Kunlun-Builder            | ⏱ 推迟一天   | Kunlun Builder, 全局       | [从kunlun-builder 仓库迁移到 Monorepo 仓库计划](https://bytedance.feishu.cn/wiki/NkTfwvOuaibxWTk4RXtcmhi4nGg) |        |        |
| 完成编写【Draft】运行时UIDL拆分技术方案 | ✅ 已完成     | Kunlun Builder, 子页面拆分 | [【UIDL拆分Draft-1】运行时UIDL拆分技术方案](https://bytedance.feishu.cn/docx/MbxTdkwI5oVY4bx52YLc13Lpn6g) | M      |        |
| 编写【WIP】运行时 UIDL 拆分技术方案评审 | 📈 连续到明天 | Kunlun Builder, 子页面拆分 | [【UIDL拆分Draft-2】运行时UIDL拆分技术方案评审](https://bytedance.feishu.cn/docx/CgfFdaRODoisvkxWwVScQhNYnif) |        |        |
| 发布保存中状态下强制显示loading态       | ✅ 已完成     | Kunlun Builder, 自动保存   | [feat: 发布保存中状态下强制显示loading态](https://code.byted.org/nclc-platform/kunlun-builder/commit/0901acda053ced9adf828ab1f2317bc87fa1d46e) | S      |        |
| 本地开发默认进入模拟一体化外框模式      | ✅ 已完成     | Kunlun Builder, 自动保存   | [chore: 本地开发默认进入模拟一体化外框模式](https://code.byted.org/nclc-platform/kunlun-builder/commit/6bf7a97841bcf06b56e76e16ed228c2d8af734aa) | S      |        |
| 修复页面需要传参时未打开草稿预览页      | ✅ 已完成     | Kunlun Builder, 自动保存   | [fix: 修复页面需要传参时未打开草稿预览页](https://code.byted.org/nclc-platform/kunlun-builder/commit/a3539d7ca74b159c02fd7d06de1053397e34dac4) | XS     |        |

### 笔记

- [【UIDL拆分Draft-1】运行时UIDL拆分技术方案](https://bytedance.feishu.cn/docx/MbxTdkwI5oVY4bx52YLc13Lpn6g) 

### 明日计划

- 完善【WIP】运行时 UIDL 拆分技术方案评审

---

## 4月21日（休假✌️）

### 笔记

- @李玉北 @张帅 都询问「引用收集」的技术细节
  - 现已实装：
    - ID收集方案 [元数据引用方式ID收集方案](https://bytedance.feishu.cn/wiki/wikcn0jSzOogwBjNqftunAt49Sd) 
    - Type-Content收集方案 [元数据引用方式技术方案](https://bytedance.feishu.cn/docx/UfnmdKm4Goimnax8PUiceBU8nqb) 
    - 特化收集记录
    - 组件ID特征收集
  - 未来新增：
    - ByteFX的AST分析出依赖
    - 通过后端APIID治理后的数据特征来收集 [APIID统一生成规则方案](https://bytedance.feishu.cn/docx/Y4fBd8kwFotbJRx7m7VcZiK7nvf) 
  - Q2要做的事：把对元数据的引用精确到组件维度

---

## 4月20日

| 工作事项                                      | 进度         | 项目                       | 文档                                                         | 工作量 | 协作者 |
| --------------------------------------------- | ------------ | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 修复data-variable中getLog没有判断传入参数类型 | ✅ 已完成     | Kunlun Builder, 全局       | [fix: 修复data-variable中getLog没有判断传入参数类型](https://code.byted.org/nclc-platform/kunlun-builder/commit/4938ce3cacac245688aba7e0e4b88f4d739d5dd2) | M      |        |
| 产出UIDL拆分技术方案                          | 📈 连续到明天 | Kunlun Builder, 子页面拆分 | [【WIP】UIDL拆分技术方案](https://bytedance.feishu.cn/docx/MbxTdkwI5oVY4bx52YLc13Lpn6g) | XL     |        |
| 修复复合组件属性面板间距样式错误              | ✅ 已完成     | Kunlun Builder, 复合组件   | [fix: 修复复合组件属性面板间距样式错误](https://code.byted.org/nclc-platform/kunlun-builder/commit/004948cb694c3749b571b37c19e1251b37bc128f) | XS     |        |
| 修复复合组件编辑属性弹层间距                  | ✅ 已完成     | Kunlun Builder, 复合组件   | [fix: 修复复合组件编辑属性弹层间距](https://code.byted.org/nclc-platform/kunlun-builder/commit/ed08c7aae68595bb7b89907008a45d7450c6fd6e) | XS     |        |
| 修复复合组件布尔属性按钮过大                  | ✅ 已完成     | Kunlun Builder, 复合组件   | [fix: 修复复合组件布尔属性按钮过大](https://code.byted.org/nclc-platform/kunlun-builder/commit/2b758047d61349626ab875d777f8df7bb551f5da) | XS     |        |

### 笔记

- 有一个线上问题，action_log传入的参数是[object%20Object]，看了代码是因为recordId为空时传入的是{recordId: undefined}，预期是undefined，这导致判空的错误处理没生效

### 明日计划

- 产出UIDL拆分技术方案

---

## 4月19日

| 工作事项                                           | 进度     | 项目                       | 文档                                                         | 工作量 | 协作者 |
| -------------------------------------------------- | -------- | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| Builder2.0对API ID结构依赖梳理                     | ✅ 已完成 | Kunlun Builder, API ID治理 | [Builder2.0对API ID结构依赖梳理](https://bytedance.feishu.cn/docx/G8cpdRuFioPqLwxJj2IcEJIhnvd) | M      |        |
| 和@李全刚 对齐APIID结构治理上下文                  | ✅ 已完成 | Kunlun Builder, API ID治理 |                                                              |        | 李全刚 |
| 修复自动保存防抖函数没有返回Promise导致await不生效 | ✅ 已完成 | Kunlun Builder, 自动保存   | [fix: 修复自动保存防抖函数没有返回Promise导致await不生效](https://code.byted.org/nclc-platform/kunlun-builder/commit/41e066053f28eb0585c47081543f247407bc80e4) | M      |        |
| 防止前一个请求未放回结果就发送下一个请求           | ✅ 已完成 | Kunlun Builder, 自动保存   | [fix: 防止前一个请求未放回结果就发送下一个请求](https://code.byted.org/nclc-platform/kunlun-builder/commit/5a3af5d08ee43b13e35731aa3d1188971e26de53) | M      |        |
| 修复值系统valueResolver未初始化无限循环            | ✅ 已完成 | Kunlun Builder, 全局       | [fix: 修复值系统valueResolver未初始化无限循环](https://code.byted.org/nclc-platform/kunlun-builder/commit/fb298c64563eebb8a51658adf124054123ad6ff5) | M      |        |

### 笔记

- [Builder2.0对API ID结构依赖梳理](https://bytedance.feishu.cn/docx/G8cpdRuFioPqLwxJj2IcEJIhnvd) 

### 明日计划

- 启动UIDL拆分

---

## 4月18日

| 工作事项                                          | 进度       | 项目                       | 文档                                                         | 工作量 | 协作者             |
| ------------------------------------------------- | ---------- | -------------------------- | ------------------------------------------------------------ | ------ | ------------------ |
| 阅读从kunlun-builder 仓库迁移到 Monorepo 仓库计划 | ⏱ 推迟一天 | Kunlun Builder, 全局       |                                                              |        |                    |
| 调研APIID统一生成规则方案                         | ⏱ 推迟一天 | Kunlun Builder, API ID治理 |                                                              |        |                    |
| 调研Hindley-Milner算法                            | ✅ 已完成   | Kunlun Builder, 类型系统   |                                                              |        |                    |
| 调研checker.ts早期版本                            | ⏱ 推迟一天 | Kunlun Builder, 类型系统   |                                                              |        |                    |
| 调研Formily代码风格                               | ✅ 已完成   | Kunlun Builder, 类型系统   |                                                              |        |                    |
| 调研《A Fresh View at Type Inference》            | ✅ 已完成   | Kunlun Builder, 类型系统   |                                                              |        |                    |
| 编写类型理论支撑调研：Hindley-Milner System (HMS) | ✅ 已完成   | Kunlun Builder, 类型系统   | [类型理论支撑调研：Hindley-Milner System (HMS)](https://bytedance.feishu.cn/docx/NlecdQH85oZ3LmxstgscA4ion9d) | XL     |                    |
| 编辑器加锁状态禁止调用保存接口                    | ✅ 已完成   | Kunlun Builder, 自动保存   | [fix: 编辑器加锁状态禁止调用保存接口](https://code.byted.org/nclc-platform/kunlun-builder/commit/258326f77edd4b978a9383a816a591fb434e4276) | S      | 王智力,唐词伟,李航 |

### 笔记

- 加锁状态之前有个bug，画布点击有些组件（宫格项）会触发会触发调用保存接口，现在改了下直接在调接口的地方阻止调用，绕过了这个bug
- A Fresh View at Type Inference.pdf
- [类型理论支撑调研：Hindley-Milner System (HMS)](https://bytedance.feishu.cn/docx/NlecdQH85oZ3LmxstgscA4ion9d) 

---

## 4月17日

| 工作事项                                  | 进度         | 项目                       | 文档                                                         | 工作量 | 协作者 |
| ----------------------------------------- | ------------ | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 预调研APIID统一生成规则方案               | ✅ 已完成     | Kunlun Builder, API ID治理 | [APIID统一生成规则方案](https://bytedance.feishu.cn/docx/Y4fBd8kwFotbJRx7m7VcZiK7nvf) | S      | 李全刚 |
| 调研值系统类型部分代码                    | ⏱ 推迟一天   | Kunlun Builder, 类型系统   |                                                              |        |        |
| 调研TypeScript类型推导引擎实现            | 📈 连续到明天 | Kunlun Builder, 类型系统   |                                                              |        |        |
| 编写类型理论支撑调研：TS编译器TypeChecker | ✅ 已完成     | Kunlun Builder, 类型系统   | [类型理论支撑调研：TS编译器TypeChecker](https://bytedance.feishu.cn/docx/CEzEdCkWDooO8GxPoCxc0xLjnkc) | XL     |        |

### 笔记

- 预调研[APIID统一生成规则方案](https://bytedance.feishu.cn/docx/Y4fBd8kwFotbJRx7m7VcZiK7nvf) 识别到一个风险：APIID治理可能会对builder1.0(kunlun-fe)产生影响，但没有指派同学进去梳理（@范财杰 ）
- [类型理论支撑调研：TS编译器TypeChecker](https://bytedance.feishu.cn/docx/CEzEdCkWDooO8GxPoCxc0xLjnkc) 

### 明日计划

- 阅读[从kunlun-builder 仓库迁移到 Monorepo 仓库计划](https://bytedance.feishu.cn/wiki/NkTfwvOuaibxWTk4RXtcmhi4nGg) 
- 调研[APIID统一生成规则方案](https://bytedance.feishu.cn/docx/Y4fBd8kwFotbJRx7m7VcZiK7nvf) 
- 调研`Hindley-Milner`算法
- 调研`checker.ts`早期版本
- 调研`Formly`代码风格

---

## 4月14日

| 工作事项                               | 进度     | 项目                       | 文档                                                         | 工作量 | 协作者 |
| -------------------------------------- | -------- | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 重构自动保存服务抽离外部逃逸部分监听器 | ✅ 已完成 | Kunlun Builder, 自动保存   | [refactor: 重构自动保存服务抽离外部逃逸部分监听器](https://code.byted.org/nclc-platform/kunlun-builder/commit/cbd306b8ee84badae9d89a6732e06a8ffba0be07) | L      |        |
| api响应策略登陆失效提示词更加语义化    | ✅ 已完成 | Kunlun Builder, API处理    | [perf: api响应策略登陆失效提示词更加语义化](https://code.byted.org/nclc-platform/kunlun-builder/commit/4e8c04402fb3f1c29d047decface2794e6363822) | XS     |        |
| Review文档元数据（字段）消费位置感知   | ✅ 已完成 | Kunlun Builder, 元数据引用 |                                                              |        |        |
| api响应策略接入双端错误提示            | ✅ 已完成 | Kunlun Builder, API处理    | [feat: api响应策略接入双端错误提示](https://code.byted.org/nclc-platform/kunlun-builder/commit/5ee1a35e3e3c3dbc5a47714d63d784b79782d734) | S      |        |
| 规范API调用枚举方法                    | ✅ 已完成 | Kunlun Builder, API处理    | [chore: 规范API调用枚举方法](https://code.byted.org/nclc-platform/kunlun-builder/commit/d5e8c73f750426f747cb190d9b647b9ed1eb4e76) | S      |        |
| urlService标注废弃API                  | ✅ 已完成 | Kunlun Builder, API处理    | [chore: urlService标注废弃API](https://code.byted.org/nclc-platform/kunlun-builder/commit/a18ac21f60f71a562a16d61afa4b43fbd655eb19) | XS     | 唐词伟 |

### 明日计划

- 预调研[APIID统一生成规则方案](https://bytedance.feishu.cn/docx/Y4fBd8kwFotbJRx7m7VcZiK7nvf) 
- 调研值系统类型部分代码
- 调研TypeScript类型推导引擎实现

---

## 4月13日

| 工作事项                                        | 进度       | 项目                    | 文档                                                         | 工作量 | 协作者 |
| ----------------------------------------------- | ---------- | ----------------------- | ------------------------------------------------------------ | ------ | ------ |
| 支持策略参数控制策略行为、警告、弹窗、上报      | ✅ 已完成   | Kunlun Builder, API处理 | [feat: 支持策略参数控制策略行为、警告、弹窗、上报](https://code.byted.org/nclc-platform/kunlun-builder/commit/173d0455b93caa5fb531635d2c860309669f0d0d) | M      |        |
| 无权限策略支持通过参数强制跳转到无权限页        | ✅ 已完成   | Kunlun Builder, API处理 | [feat: 无权限策略支持通过参数强制跳转到无权限页](https://code.byted.org/nclc-platform/kunlun-builder/commit/40d06ee1220ea668c2bb04bb9d8d7f7df15d6e86) | S      |        |
| 增加重载策略与未授权策略                        | ✅ 已完成   | Kunlun Builder, API处理 | [feat: 增加重载策略与未授权策略](https://code.byted.org/nclc-platform/kunlun-builder/commit/9366bca2d6c4f8a811c8fa2eb059c512146096c3) | M      |        |
| api响应策略生成防抖对话框                       | ✅ 已完成   | Kunlun Builder, API处理 | [feat: api响应策略生成防抖对话框](https://code.byted.org/nclc-platform/kunlun-builder/commit/492aec9f57d6b5971a019fa869f42a31b46cb51e) | S      |        |
| api响应策略收口选项                             | ✅ 已完成   | Kunlun Builder, API处理 | [refactor: api响应策略收口选项](https://code.byted.org/nclc-platform/kunlun-builder/commit/c9d0ad102c05469398f583978d6fee2256538883) | M      |        |
| api响应策略通用方法移入utils                    | ✅ 已完成   | Kunlun Builder, API处理 | [refactor: api响应策略通用方法移入utils](https://code.byted.org/nclc-platform/kunlun-builder/commit/b9bbbdfa0e664c7d8be652abefc5ddaf3df3b48f) | S      |        |
| api响应策略增加Token失效策略并接入重载页面功能  | ✅ 已完成   | Kunlun Builder, API处理 | [feat: api响应策略增加Token失效策略并接入重载页面功能](https://code.byted.org/nclc-platform/kunlun-builder/commit/7eda8d2c8a05c62532dd85950f90e91e0eb07a8f) | M      |        |
| api响应策略增加请求参数错误策略                 | ✅ 已完成   | Kunlun Builder, API处理 | [feat: api响应策略增加请求参数错误策略](https://code.byted.org/nclc-platform/kunlun-builder/commit/61f503d721b2297d7a334e7a3b61cecb19632c96) | S      |        |
| api响应策略新增动作无法启用策略                 | ✅ 已完成   | Kunlun Builder, API处理 | [feat: api响应策略新增动作无法启用策略](https://code.byted.org/nclc-platform/kunlun-builder/commit/b14a9a7289d55f21c56260a6f2f9b56656fa6518) | M      |        |
| api响应策略新增请求流程动作失败策略             | ✅ 已完成   | Kunlun Builder, API处理 | [feat: api响应策略新增请求流程动作失败策略](https://code.byted.org/nclc-platform/kunlun-builder/commit/ed91e1a06dad8f5f6e2a86e0767f9b58d8178e5a) | S      |        |
| api响应策略新增函数超时策略                     | ✅ 已完成   | Kunlun Builder, API处理 | [feat: api响应策略新增函数超时策略](https://code.byted.org/nclc-platform/kunlun-builder/commit/f2a839bf184aae51686820bad592555833a67c0b) | M      |        |
| api响应策略新增报表无权限策略                   | ✅ 已完成   | Kunlun Builder, API处理 | [feat: api响应策略新增报表无权限策略](https://code.byted.org/nclc-platform/kunlun-builder/commit/feecb910f146ac299c0fae00b34b24ac0d112352) | XS     |        |
| api响应策略封装跳转无权限页以便统一增加前置报警 | ✅ 已完成   | Kunlun Builder, API处理 | [perf: api响应策略封装跳转无权限页以便统一增加前置报警](https://code.byted.org/nclc-platform/kunlun-builder/commit/ce0b5c94a2e797014ce323d813599afc033688a3) | S      |        |
| api响应策略新增应用被删除策略                   | ✅ 已完成   | Kunlun Builder, API处理 | [feat: api响应策略新增应用被删除策略](https://code.byted.org/nclc-platform/kunlun-builder/commit/5739c7e68e67186f4bc73bb7fcd94b018ba53487) | M      |        |
| api响应无法启用流程策略防止有extra未传情况      | ✅ 已完成   | Kunlun Builder, API处理 | [fix: api响应无法启用流程策略防止有extra未传情况](https://code.byted.org/nclc-platform/kunlun-builder/commit/f3a9c4f729ae0c75b56841db83696389413f3faa) | XS     |        |
| api响应适配参数传入                             | ⏱ 推迟一天 | Kunlun Builder, API处理 |                                                              |        |        |
| api响应适配双端                                 | ⏱ 推迟一天 | Kunlun Builder, API处理 |                                                              |        |        |
| api调用方添加参数（参考kunlun-fe）              | ⏱ 推迟一天 | Kunlun Builder, API处理 |                                                              |        |        |

### 明日计划

- 复合组件BUG清空
- api响应适配参数传入
- api响应适配双端
- api调用方添加参数（参考kunlun-fe）
- 提交前监听自动保存状态
- 看文档[元数据（字段）消费位置感知](https://bytedance.feishu.cn/docx/ZxC9dWpqTo6jYaxSEHKcS0JSnzh) 

---

## 4月12日

| 工作事项                                   | 进度       | 项目                       | 文档                                                         | 工作量 | 协作者 |
| ------------------------------------------ | ---------- | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 阅读 Fx 接入 Builder 链路使用 ADT 协议推导 | ⏱ 推迟一天 | Kunlun Builder, 类型系统   |                                                              |        |        |
| 移除全局滚动条样式覆盖合入班车             | ✅ 已完成   | Kunlun Builder, 全局       |                                                              | XS     |        |
| 修复crypto.randomUUID在92以下chrome未支持  | ✅ 已完成   | Kunlun Builder, 全局       | [fix: 修复crypto.randomUUID在92以下chrome未支持](https://code.byted.org/nclc-platform/kunlun-builder/commit/a058654e21bfb8c64a22e6ab10545d503a9e779f) | S      |        |
| 推导引擎的具体规划明确时间点               | ✅ 已完成   | Kunlun Builder, 类型系统   | [ADT类型推导引擎Roadmap](https://bytedance.feishu.cn/docx/BqtwdVFhfo1MnAx3dipchvienNf) | M      |        |
| 子页面拆分需求估时                         | ✅ 已完成   | Kunlun Builder, 子页面拆分 |                                                              |        | 谭继臻 |

### 笔记

- 子页面拆分需求
  - 【阶段一】运行时拆分，仅需前端开发（共15人日，4.20-5.10）
    - 根据演示Demo里的Hard Code验证性能优化效果（@谭继臻 主导）
    - 运行时UIDL拆分技术方案设计与评审（5人日）
    - UIDL拆分方法从0到1开发（5人日）
    - UIDL拆分方法接入运行时基座（1人日）
    - 适配导航动态加载UIDL片段从0到1开发（4人日）
  - 【阶段二】设计器保存前拆分，需前后端协同开发
    - 设计态UIDL拆分技术方案设计与评审
    - UIDL拆分方法接入设计器基座
    - 设计态保存接口改造接入
    - 后端UIDL拼接算法开发
    - 运行时接入UIDL片段请求
- [ADT类型推导引擎Roadmap](https://bytedance.feishu.cn/docx/BqtwdVFhfo1MnAx3dipchvienNf) 

---

## 4月11日

| 工作事项                                   | 进度       | 项目                     | 文档                                                         | 工作量 |
| ------------------------------------------ | ---------- | ------------------------ | ------------------------------------------------------------ | ------ |
| 阅读 Fx 接入 Builder 链路使用 ADT 协议推导 | ⏱ 推迟一天 | Kunlun Builder, 类型系统 |                                                              |        |
| 项目大盘梳理                               | ✅ 已完成   | Bytedance                | [aPaaS Runtime 宝典](https://bytedance.feishu.cn/docx/IF4udhHRXoOlqdx1jJaccIa5n0y) | M      |
| OKR的草稿针对ADT Schema细化                | ✅ 已完成   | Bytedance                | [Q2 OKR](https://bytedance.feishu.cn/docx/FvMPdjTPboTKeWxWHvpc34b4nMb) | XS     |
| 整理运行时架构团队BUG视图                  | ✅ 已完成   | Bytedance                | https://meego.feishu.cn/apaas_/issueView/Dy19S_L4R           | S      |
| 移除全局滚动条样式覆盖合入班车             | ⏱ 推迟一天 | Kunlun Builder, 全局     |                                                              |        |
| urlService增加404与无权限页路径功能        | ✅ 已完成   | Kunlun Builder, API处理  | [feat: urlService增加404与无权限页路径功能](https://code.byted.org/nclc-platform/kunlun-builder/commit/f49bc363036e051ac8c316a8f61a4b7b0ee8ae5d) | S      |
| 允许策略禁用通知/告警/日志                 | ✅ 已完成   | Kunlun Builder, API处理  | [feat: 允许策略禁用通知/告警/日志](https://code.byted.org/nclc-platform/kunlun-builder/commit/7eeddcaa3b82da00f0a5cae36cd490fe7ebfcdd6) | M      |
| api响应处理错误报警与错误国际化消息横幅    | ✅ 已完成   | Kunlun Builder, API处理  | [feat: api响应处理错误报警与错误国际化消息横幅](https://code.byted.org/nclc-platform/kunlun-builder/commit/134727de0fadaefd3872c5c6f6b0daaf6ce6a9b9) | M      |
| api响应处理增加成功策略                    | ✅ 已完成   | Kunlun Builder, API处理  | [feat: api响应处理增加成功策略](https://code.byted.org/nclc-platform/kunlun-builder/commit/40b5d48096094c159ba1d2731b52420ec588120f) | S      |
| api响应策略注册并接入请求                  | ✅ 已完成   | Kunlun Builder, API处理  | [feat: api响应策略注册并接入请求](https://code.byted.org/nclc-platform/kunlun-builder/commit/067ae840e9052c435c6b6f28377d9011d97a9aff) | M      |
| 修复api响应处理未初始化map                 | ✅ 已完成   | Kunlun Builder, API处理  | [fix: 修复api响应处理未初始化map](https://code.byted.org/nclc-platform/kunlun-builder/commit/42c2e2f34661c0ba02d0d474f7c23da692bd5a2d) | XS     |

### 笔记

- （风险点）这里面的`status_code`是个i18n key，但kunlun-builder国际化locales目录下找不到这个key，kunlun-fe能找到

![img](https://bytedance.larkoffice.com/space/api/box/stream/download/asynccode/?code=NTM3NzA1MDM5ZDVhMzhhMDA4MTZlMWQ0ZmM4YTg1NDdfbElHWVlXWDZaZ0tyWWkxTExrdWFzMUNkTThJd3NnaHdfVG9rZW46VHpRVGJXbzR5b1Z5VGN4NXM5ZGNYYUtsbkxkXzE3MDAxMzM0OTM6MTcwMDEzNzA5M19WNA)

- API响应策略自测点
  - 报错的横幅不会一瞬间弹出非常多
  - 报错的标语更加语义化，不会有看不懂的代码在上面
  - 报错标语适配多端
  - 部分报错，非法参数，请求动作失败的提示更全
  - 部分报错，无权限，应用被禁用，无包权限编辑的提示会被屏蔽
  - 部分报错，对象被删除，关联字段被删除，报表无权限，会直接跳转无权限页
  - 部分报错，非法token，激活动作错误会弹出确认框，确认后重载页面
  - 部分报错，包删除，沙箱包删除跳转页面被删除页面

### 明日计划

- 移除全局滚动条样式覆盖合入班车
- 低版本浏览器不支持crypto.randomUUID()
- 推导引擎的具体规划明确时间点，参考[Rehaje Roadmap](https://bytedance.feishu.cn/docx/KGBJdrCWEoryxaxxPzFcKjxfnhg) ，需要与@王智力 对齐Q2目标
- 阅读 [Fx 接入 Builder 链路使用 ADT 协议推导 ](https://bytedance.feishu.cn/docx/O2bAd062KoItDQx5820cqsVKngg) 

---

## 4月10日

| 工作事项                                | 进度         | 项目                       | 文档                                                         | 工作量 | 协作者 |
| --------------------------------------- | ------------ | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 移除全局滚动条样式覆盖合入班车          | 📈 连续到明天 | Kunlun Builder, 全局       | [chore: 移除全局滚动条样式覆盖](https://code.byted.org/nclc-platform/kunlun-builder/commit/230597b62a33bd7ac49681a0a02c0d04df565950) | XS     | 刘路   |
| 调研TypeScript Language Server          | ⏱ 推迟一天   | Kunlun Builder, 类型系统   |                                                              |        |        |
| 阅读《Types and Programming Languages》 | ⏱ 推迟一天   | Kunlun Builder, 类型系统   |                                                              |        |        |
| api响应处理策略类型                     | ✅ 已完成     | Kunlun Builder, API处理    | [feat: api响应处理策略类型](https://code.byted.org/nclc-platform/kunlun-builder/commit/62423fe6218f7d8d8aac8ab779972e95b5fa3f67) | S      |        |
| api响应处理策略类型状态码整理           | ✅ 已完成     | Kunlun Builder, API处理    | [feat: api响应处理策略类型状态码整理](https://code.byted.org/nclc-platform/kunlun-builder/commit/de59134a206f68c8195f235445f161021ac19447) | S      |        |
| api响应处理策略处理器                   | ✅ 已完成     | Kunlun Builder, API处理    | [feat: api响应处理策略处理器](https://code.byted.org/nclc-platform/kunlun-builder/commit/36a79dba8554574c51f3755b8fdb7219ca8714ae) | M      |        |
| api响应处理无权限策略                   | ✅ 已完成     | Kunlun Builder, API处理    | [feat: api响应处理无权限策略](https://code.byted.org/nclc-platform/kunlun-builder/commit/3da168961199fcc46209ed24e9dd9997fd2b03de) | S      |        |
| 子页面拆分代码迁移改造方案              | ✅ 已完成     | Kunlun Builder, 子页面拆分 |                                                              | S      | 谭继臻 |

### 笔记

- 子页面拆分采用Service监听导航变动来动态加载UIDL

### 明日计划

- 项目大盘梳理
- OKR的草稿针对ADT Schema细化
- 阅读 [Fx 接入 Builder 链路使用 ADT 协议推导 ](https://bytedance.feishu.cn/docx/O2bAd062KoItDQx5820cqsVKngg) 

---

## 4月9日（周末🏝️）

| 工作事项                 | 进度     | 项目                     | 文档                                                         | 工作量 | 协作者 |
| ------------------------ | -------- | ------------------------ | ------------------------------------------------------------ | ------ | ------ |
| 调研类型推导引擎         | ✅ 已完成 | Kunlun Builder, 类型系统 |                                                              | M      |        |
| ADTInferEngine是什么文档 | ✅ 已完成 | Kunlun Builder, 类型系统 | [类型推导引擎ADTInferEngine是什么](https://bytedance.feishu.cn/docx/QUqXdJ7KEocpc2xxraicBvunnWc) | M      |        |

### 笔记

- [类型推导引擎ADTInferEngine是什么](https://bytedance.feishu.cn/docx/QUqXdJ7KEocpc2xxraicBvunnWc) 
- Types and Programming Languages.pdf
- 类型和程序设计语言_11393905.pdf

---

## 4月7日

| 工作事项                                           | 进度       | 项目                     | 文档                                                         | 工作量 | 协作者 |
| -------------------------------------------------- | ---------- | ------------------------ | ------------------------------------------------------------ | ------ | ------ |
| 把Q2需要做的事排入Q2研发工作规划                   | ⏱ 推迟一天 | Bytedance                |                                                              |        |        |
| 修复复合组件删除属性按钮热区不够大                 | ✅ 已完成   | Kunlun Builder, 复合组件 | [fix: 修复复合组件删除属性按钮热区不够大](https://code.byted.org/nclc-platform/kunlun-builder/commit/cdba774e33af8fb8055901d46b941d585522f3f8) | XS     |        |
| 延迟tooltip收起时间防止无法复制                    | ✅ 已完成   | Kunlun Builder, 复合组件 | [perf: 延迟tooltip收起时间防止无法复制](https://code.byted.org/nclc-platform/kunlun-builder/commit/955799ce97565995a436ef3bd04d59bab6f2946d) | XS     |        |
| 复合组件模型增加类型注释                           | ✅ 已完成   | Kunlun Builder, 复合组件 | [perf: 复合组件模型增加类型注释](https://code.byted.org/nclc-platform/kunlun-builder/commit/e9c2f079a7008e19649f6448b0d303e1f31812a4) | S      |        |
| 复合组件连接器增加注释                             | ✅ 已完成   | Kunlun Builder, 复合组件 | [perf: 复合组件连接器增加注释](https://code.byted.org/nclc-platform/kunlun-builder/commit/f9aab51aec45010c41780b09077f6bc133f15469) | S      |        |
| 复合组件类型物料增加注释                           | ✅ 已完成   | Kunlun Builder, 复合组件 | [perf: 复合组件类型物料增加注释](https://code.byted.org/nclc-platform/kunlun-builder/commit/c1cef2fec1911e704e4ad5edc7b9ebed0bc40a0b) | S      |        |
| 重构复合组件连接器结构                             | ✅ 已完成   | Kunlun Builder, 复合组件 | [refactor: 重构复合组件连接器结构](https://code.byted.org/nclc-platform/kunlun-builder/commit/66a6af68883792be1b4dc73665762255ac84953e) | M      |        |
| 复合组件报错改为console防止页面白屏                | ✅ 已完成   | Kunlun Builder, 复合组件 | [perf: 复合组件报错改为console防止页面白屏](https://code.byted.org/nclc-platform/kunlun-builder/commit/bc1cb9bc7fc337a01a68ba981f260c8ca51b3ba9) | S      |        |
| 支持复合组件动态加载外部库                         | ✅ 已完成   | Kunlun Builder, 复合组件 | [feat: 支持复合组件动态加载外部库](https://code.byted.org/nclc-platform/kunlun-builder/commit/609660506cf6190fd85a48cb1ddc615ff02ba8f4) | M      |        |
| 重构复合组件模型支持挂载监听器与动态启用监听器能力 | ✅ 已完成   | Kunlun Builder, 复合组件 | [refactor: 重构复合组件模型支持挂载监听器与动态启用监听器能力](https://code.byted.org/nclc-platform/kunlun-builder/commit/81de20355dc29dba9a9c2d2f84de773783a5e815) | L      |        |

### 笔记

- 复合组件完成收尾，等待上线

### 明日计划

- 调研类型推导引擎是什么
- 把Q2需要做的事排入Q2研发工作规划

---

## 4月6日

| 工作事项                                   | 进度         | 项目                     | 文档                                                         | 工作量 | 协作者 |
| ------------------------------------------ | ------------ | ------------------------ | ------------------------------------------------------------ | ------ | ------ |
| 把Q2需要做的事排入Q2研发工作规划           | ⏱ 推迟一天   | Bytedance                |                                                              |        |        |
| 复合组件模型生命周期管理                   | ⏰ 无限期推迟 | Kunlun Builder, 复合组件 |                                                              |        |        |
| 修复复合组件未编辑API名称却过不了校验      | ✅ 已完成     | Kunlun Builder, 复合组件 | [fix: 修复复合组件未编辑API名称却过不了校验](https://code.byted.org/nclc-platform/kunlun-builder/commit/5fd377c120fda84120aeeeb0f2a4ce57d0c9e4b0) | S      |        |
| 复合组件属性编辑面板内部padding错误        | ✅ 已完成     | Kunlun Builder, 复合组件 | [fix: 复合组件属性编辑面板内部padding错误](https://code.byted.org/nclc-platform/kunlun-builder/commit/4b67f0c90b4d48397d65e30590d403ae0b9de426) | XS     |        |
| 复合组件编辑组件属性按钮高度错误           | ✅ 已完成     | Kunlun Builder, 复合组件 | [fix: 复合组件编辑组件属性按钮高度错误](https://code.byted.org/nclc-platform/kunlun-builder/commit/3c1e1118294756f771717bc5343db1fc441c16fd) | XS     |        |
| 修复复合组件popover限定高度不对            | ✅ 已完成     | Kunlun Builder, 复合组件 | [fix: 修复复合组件popover限定高度不对](https://code.byted.org/nclc-platform/kunlun-builder/commit/907c6488dd19a5145d3edff1185afc2942f593a4) | XS     |        |
| 复合组件输出面板编辑icon大小不对           | ✅ 已完成     | Kunlun Builder, 复合组件 | [fix: 复合组件输出面板编辑icon大小不对](https://code.byted.org/nclc-platform/kunlun-builder/commit/07c98242cc08b4628f9f8bf542d3a2fcbb117a6b) | XS     |        |
| 复合组件删除输入属性的Dropdown打开时丢失态 | ✅ 已完成     | Kunlun Builder, 复合组件 | [fix: 复合组件删除输入属性的Dropdown打开时丢失态](https://code.byted.org/nclc-platform/kunlun-builder/commit/39b377dfbf3744dc91ece67f8c6d24621a597e50) | S      |        |
| 复合组件编辑组件属性标题区样式不对         | ✅ 已完成     | Kunlun Builder, 复合组件 | [fix: 复合组件编辑组件属性标题区样式不对](https://code.byted.org/nclc-platform/kunlun-builder/commit/39839a3ad141c245c6c101ea02c63ef510bdc5d4) | M      |        |
| 复合组件适配输入属性面板上间距             | ✅ 已完成     | Kunlun Builder, 复合组件 | [chore: 复合组件适配输入属性面板上间距](https://code.byted.org/nclc-platform/kunlun-builder/commit/7fdc40469577e557cc1af7cd5b1ebad432da151a) | XS     |        |

### 明日计划

- 把Q2需要做的事排入Q2研发工作规划
- 复合组件收尾
  - 代码增加注释
  - 模型支持监听器
  - 模型支持动态加载库
  - 抛错改为console.error
  - 国际化

---

## 4月5日

| 工作事项                                   | 进度     | 项目                     | 文档                                                         | 工作量 | 协作者      |
| ------------------------------------------ | -------- | ------------------------ | ------------------------------------------------------------ | ------ | ----------- |
| OKR草稿                                    | ✅ 已完成 | Bytedance                | [Q2 OKR](https://bytedance.feishu.cn/docx/FvMPdjTPboTKeWxWHvpc34b4nMb) | S      |             |
| Q2工作项排期（甘特图）                     | ✅ 已完成 | Bytedance                | [Q2需要做的事](https://bytedance.feishu.cn/docx/Cxbdd0IOMo1u53xGUDRcQF1nnFY) | M      |             |
| 对齐Q2工作项风险@王智力 @张帅              | ✅ 已完成 | Bytedance                | [Q2需要做的事](https://bytedance.feishu.cn/docx/Cxbdd0IOMo1u53xGUDRcQF1nnFY) | S      | 王智力,张帅 |
| 新建页面，不提交直接预览时提示无权限c      | ✅ 已完成 | Kunlun Builder, 权限     | [fix: 修复新建草稿预览页后显示无权限](https://code.byted.org/nclc-platform/kunlun-builder/commit/a795312b3d45831eca91ea97c9492fd6e2eb3683) | S      | 唐词伟      |
| 屏蔽无权限状态码                           | ✅ 已完成 | Kunlun Builder, 权限     | [fix: 修复频繁出现无权限报错](https://code.byted.org/nclc-platform/kunlun-builder/commit/4d2b314749a12f5a1ee3df22f7641ad1a5e4580f) | XS     |             |
| 沙箱工具页面名称长度溢出处理               | ✅ 已完成 | Kunlun Builder, 权限     | [fix: 修复身份模拟工具条页面名称长度溢出](https://code.byted.org/nclc-platform/kunlun-builder/commit/85d249736e0879b3ba2869cdaecee1382808ff1d) | S      |             |
| 修复复合组件未编辑API名称却过不了校验      | ✅ 已完成 | Kunlun Builder, 复合组件 | [fix: 修复复合组件未编辑API名称却过不了校验](https://code.byted.org/nclc-platform/kunlun-builder/commit/5fd377c120fda84120aeeeb0f2a4ce57d0c9e4b0) | M      |             |
| 复合组件属性编辑面板内部padding错误        | ✅ 已完成 | Kunlun Builder, 复合组件 | [fix: 复合组件属性编辑面板内部padding错误](https://code.byted.org/nclc-platform/kunlun-builder/commit/4b67f0c90b4d48397d65e30590d403ae0b9de426) | XS     |             |
| 复合组件编辑组件属性按钮高度错误           | ✅ 已完成 | Kunlun Builder, 复合组件 | [fix: 复合组件编辑组件属性按钮高度错误](https://code.byted.org/nclc-platform/kunlun-builder/commit/3c1e1118294756f771717bc5343db1fc441c16fd) | XS     |             |
| 修复复合组件popover限定高度不对            | ✅ 已完成 | Kunlun Builder, 复合组件 | [fix: 修复复合组件popover限定高度不对](https://code.byted.org/nclc-platform/kunlun-builder/commit/907c6488dd19a5145d3edff1185afc2942f593a4) | XS     |             |
| 复合组件输出面板编辑icon大小不对           | ✅ 已完成 | Kunlun Builder, 复合组件 | [fix: 复合组件输出面板编辑icon大小不对](https://code.byted.org/nclc-platform/kunlun-builder/commit/07c98242cc08b4628f9f8bf542d3a2fcbb117a6b) | XS     |             |
| 复合组件删除输入属性的Dropdown打开时丢失态 | ✅ 已完成 | Kunlun Builder, 复合组件 | [fix: 复合组件删除输入属性的Dropdown打开时丢失态](https://code.byted.org/nclc-platform/kunlun-builder/commit/39b377dfbf3744dc91ece67f8c6d24621a597e50) | M      |             |
| 复合组件编辑组件属性标题区样式不对         | ✅ 已完成 | Kunlun Builder, 复合组件 | [fix: 复合组件编辑组件属性标题区样式不对](https://code.byted.org/nclc-platform/kunlun-builder/commit/39839a3ad141c245c6c101ea02c63ef510bdc5d4) | M      |             |
| 复合组件适配输入属性面板上间距             | ✅ 已完成 | Kunlun Builder, 复合组件 | [chore: 复合组件适配输入属性面板上间距](https://code.byted.org/nclc-platform/kunlun-builder/commit/7fdc40469577e557cc1af7cd5b1ebad432da151a) | S      |             |

### 笔记

- [Q2 OKR](https://bytedance.feishu.cn/docx/FvMPdjTPboTKeWxWHvpc34b4nMb) 
- [Q2需要做的事](https://bytedance.feishu.cn/docx/Cxbdd0IOMo1u53xGUDRcQF1nnFY) 

### 明日计划

- 把Q2需要做的事排入Q2研发工作规划

---

## 4月4日

| 工作事项                                 | 进度       | 项目                       | 文档                                                         | 工作量 | 协作者 |
| ---------------------------------------- | ---------- | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 修复编辑属性未校验API Name重复           | ✅ 已完成   | Kunlun Builder, 复合组件   | [fix: 修复编辑属性未校验API Name重复](https://code.byted.org/nclc-platform/kunlun-builder/commit/09e5178718ddbec52d15801bba9d39c35586160a) | S      |        |
| 修复属性面板模式错误缓存                 | ✅ 已完成   | Kunlun Builder, 复合组件   | [fix: 修复属性面板模式错误缓存](https://code.byted.org/nclc-platform/kunlun-builder/commit/a3934221e690f6a45c45117d012ced355234f338) | XS     |        |
| 修复表单标题未剧中                       | ✅ 已完成   | Kunlun Builder, 复合组件   | [fix: 修复表单标题未剧中](https://code.byted.org/nclc-platform/kunlun-builder/commit/b14f58eed81d8391e75a6bd20b844573da537d08) | S      | 项仁明 |
| 修复属性表单白边                         | ✅ 已完成   | Kunlun Builder, 复合组件   | [fix: 修复属性表单白边](https://code.byted.org/nclc-platform/kunlun-builder/commit/3b711fd55cec8aa1c26fe53fafa185dd418ff7ad) | S      | 项仁明 |
| 表单按钮最小宽度64px                     | ✅ 已完成   | Kunlun Builder, 复合组件   | [fix: 表单按钮最小宽度64px](https://code.byted.org/nclc-platform/kunlun-builder/commit/c32fb60ccd60e3f8a166cee4090b454e804290c6) | XS     | 项仁明 |
| 复合组件属性表单输入框适配hover样式      | ✅ 已完成   | Kunlun Builder, 复合组件   | [fix: 复合组件属性表单输入框适配hover样式](https://code.byted.org/nclc-platform/kunlun-builder/commit/36e0b4e69af0b6e6647ad04abfa92e10f4912db7) | S      | 项仁明 |
| 复合组件属性编辑面板内部padding错误      | ✅ 已完成   | Kunlun Builder, 复合组件   | [fix: 复合组件属性编辑面板内部padding错误](https://code.byted.org/nclc-platform/kunlun-builder/commit/7492fd427608d07e4d935815c5158da8eae48cb7) | XS     | 项仁明 |
| 复合组件编辑组件属性按钮下padding少了8px | ✅ 已完成   | Kunlun Builder, 复合组件   | [fix: 复合组件编辑组件属性按钮下padding少了8px](https://code.byted.org/nclc-platform/kunlun-builder/commit/35ffe87d1eb60dfd7571af080a949dfb54dfdd39) | XS     | 项仁明 |
| 规范Q2 OKR                               | ⏱ 推迟一天 | Bytedance                  |                                                              |        |        |
| 新建页面后，草稿预览页显示无权限         | ⏱ 推迟一天 | Kunlun Builder, 权限       |                                                              |        |        |
| 禁用无权限提示                           | ⏱ 推迟一天 | Kunlun Builder, 权限       |                                                              |        |        |
| 沙箱工具页面名称过长时溢出               | ⏱ 推迟一天 | Kunlun Builder, 权限       |                                                              |        |        |
| 思考类型系统Language Server与Builder生态 | ⏱ 推迟一天 | Kunlun Builder, 类型系统   |                                                              |        |        |
| resolveComponent性能优化路线             | ✅ 已完成   | Kunlun Builder, 子页面拆分 | [resolveComponent性能优化路线](https://bytedance.feishu.cn/mindnotes/BmpJbNJIZmroGFn7llscz1HbnHh#mindmap) | M      |        |

### 笔记

- 新建页面后，草稿预览页无法获取到UIDL，显示无权限（不符合预期）
- [resolveComponent性能优化路线](https://bytedance.feishu.cn/mindnotes/BmpJbNJIZmroGFn7llscz1HbnHh#mindmap) UIDL 拆分工作可以分两个阶段推进：
  - 在前端运行时实现一个 “UIDL 拆分 service”，负责在基座之前将 UIDL 完成拆分，减少首屏渲染 “resolveComponent” 操作的耗时，加快首屏渲染；
  - 将上述运行时操作迁移至 “设计器” 来做，服务端配合完成 “保存接口”、存储、“查询接口拼装 UIDL” 相关的改造；
- [Q2需要做的事](https://bytedance.feishu.cn/docx/Cxbdd0IOMo1u53xGUDRcQF1nnFY) 

### 明日计划

- 对齐Q2工作项风险

---

## 4月3日

| 工作事项                                     | 进度       | 项目                     | 文档                                                         | 工作量 | 协作者 |
| -------------------------------------------- | ---------- | ------------------------ | ------------------------------------------------------------ | ------ | ------ |
| 修复复合组件输出属性apiName未校验重复        | ✅ 已完成   | Kunlun Builder, 复合组件 | [fix: 修复复合组件输出属性apiName未校验重复](https://code.byted.org/nclc-platform/kunlun-builder/commit/50810b225a06e0695eb6ad4e601eabd979fde494) | S      |        |
| 复合组件属性面板不可见时销毁DOM              | ✅ 已完成   | Kunlun Builder, 复合组件 | [perf: 复合组件属性面板不可见时销毁DOM](https://code.byted.org/nclc-platform/kunlun-builder/commit/373ab5bf082e88ab0cc42ab4004bd4c3ef7b6554) | XS     |        |
| 修复复合组件屏蔽了按钮组组件                 | ✅ 已完成   | Kunlun Builder, 复合组件 | [fix: 修复复合组件屏蔽了按钮组组件](https://code.byted.org/nclc-platform/kunlun-builder/commit/3a3374444acb6c902789e60fb47c0d1e4c8681c8) | XS     | 李毅   |
| 复合组件表单默认带有placeholder的tooltip     | ⏱ 推迟一天 | Kunlun Builder, 复合组件 |                                                              |        | 李毅   |
| Kunlun Builder对齐1.0网络请求能力文档        | ✅ 已完成   | Kunlun Builder, 全局     | [Kunlun Builder对齐1.0网络请求能力](https://bytedance.feishu.cn/docx/PWqZdGjYcoPpEnxE6ERccFh9nde) | M      | 张帅   |
| 复合组件输出属性apiName溢出时通过tooltip展示 | ✅ 已完成   | Kunlun Builder, 复合组件 | [feat: 复合组件输出属性apiName溢出时通过tooltip展示](https://code.byted.org/nclc-platform/kunlun-builder/commit/83a3ea1143d8f089e7e70c493322b09075da7e20) | XS     |        |
| 复合组件类型默认表单写入类型物料             | ✅ 已完成   | Kunlun Builder, 复合组件 | [feat: 复合组件类型默认表单写入类型物料](https://code.byted.org/nclc-platform/kunlun-builder/commit/7bd0c58e9919e7ce446a7a64fb388444cda8b222) | M      |        |
| 修复复合组件编辑属性默认值无法回显           | ✅ 已完成   | Kunlun Builder, 复合组件 | [fix: 修复复合组件编辑属性默认值无法回显](https://code.byted.org/nclc-platform/kunlun-builder/commit/989c9babf4a18b04727319094278aefdafacce2d) | S      |        |
| 修复数字属性默认值超出JS最大数字限制         | ✅ 已完成   | Kunlun Builder, 复合组件 | [fix: 修复数字属性默认值超出JS最大数字限制](https://code.byted.org/nclc-platform/kunlun-builder/commit/77bbb7fedf698f95b2077beba972ba3acc5ccc48) | S      |        |
| 复合组件创建属性时自动创建默认API Name       | ✅ 已完成   | Kunlun Builder, 复合组件 | [feat: 复合组件创建属性时自动创建默认API Name](https://code.byted.org/nclc-platform/kunlun-builder/commit/ca8ce4e8615814ff73895f7611de68ba42df9b60) | S      |        |
| 需要自动生成的是API Name不是Default Value    | ✅ 已完成   | Kunlun Builder, 复合组件 | [fix: 需要自动生成的是API Name不是Default Value](https://code.byted.org/nclc-platform/kunlun-builder/commit/bf01957f52f8b468e39fb5f634a7152981d6f5b2) | XS     |        |

### 笔记

- [Kunlun Builder对齐1.0网络请求能力](https://bytedance.feishu.cn/docx/PWqZdGjYcoPpEnxE6ERccFh9nde) 

### 明日计划

- 解决掉复合组件所有UX走查BUG
- 规范Q2 OKR

---

## 4月1日（加班😩）

### 笔记

- 今天的目标是解决掉复合组件所有P1的BUG

### 明日计划

- 解决掉复合组件所有P2的BUG