## 8月31日（休假🏝️）

---

## 8月30日

| 工作事项                 | 进度     | 项目                    | 文档 | 工作量 | 协作者 |
| ------------------------ | -------- | ----------------------- | ---- | ------ | ------ |
| API响应abort缺陷修复合码 | ✅ 已完成 | Kunlun Builder, API处理 |      |        | 孙志远 |

### 笔记

- [引用收集架构图](https://bytedance.feishu.cn/docx/KsCqdbNWoonYDbxG0Oec2KJknRg) 
- [刘洋兴 -2023 interview](https://bytedance.feishu.cn/docx/JmfNdeJP7obLD0xgaEucZ5QQnfg) 
- 和@孙志远 确认了下合码情况，现在Builder的914分支不能继续合码，需要等Builder分支合入班车914分支后，才能继续通过车票合入班车分支

### 明日计划

- 缺陷修复合码

---

## 8月29日

| 工作事项                                                 | 进度         | 项目                       | 文档                                                         | 工作量 | 协作者 |
| -------------------------------------------------------- | ------------ | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| api响应处理catch逻辑固定触发reject，不根据httpStatus判断 | ✅ 已完成     | Kunlun Builder, API处理    | [perf: api响应处理catch逻辑固定触发reject，不根据httpStatus判断](https://code.byted.org/apaas/monorepo/commit/ecf9546906476b6b632a83c4bdb7c9553c3968e6) | M      |        |
| 图表接口失败try catch                                    | ⏰ 无限期推迟 | Kunlun Builder, API处理    |                                                              |        |        |
| 依赖ID的接口梳理                                         | ⏱ 推迟一天   | Kunlun Builder, 元数据引用 |                                                              |        |        |
| 流程权限入参object id类型判断                            | ✅ 已完成     | Kunlun Builder, 权限       | [fix: 修复流程权限入参未对objectId类型做检查导致错误被透出到后端](https://code.byted.org/apaas/monorepo/commit/ef908ce910d1191ce23f62b312d7c5f6904d3394) | S      |        |
| 写入fx page conf前清空原有数据                           | ✅ 已完成     | Kunlun Builder, 性能优化   | [fix: 写入fx page conf前清空原有数据](https://code.byted.org/apaas/monorepo/commit/9d72191407b3f1442a6ae49eb48b47dc794756e0?merge_request_iid=7939) | S      |        |
| 修复page conf被清空                                      | ✅ 已完成     | Kunlun Builder, 性能优化   | [fix: 修复page conf被清空](https://code.byted.org/apaas/monorepo/commit/6e748e5d6c49f91a318d14f3b8f2c265984d6f38?merge_request_iid=7939) | XS     |        |
| 图表请求失败返回空字符串原因排查                         | ✅ 已完成     | Kunlun Builder, API处理    | [图表请求失败返回空字符串原因排查](https://bytedance.feishu.cn/docx/XqHZdtVFJoDyfxx3WjbcXGcknCc) | M      |        |

### 笔记

- [图表请求失败返回空字符串原因排查](https://bytedance.feishu.cn/docx/XqHZdtVFJoDyfxx3WjbcXGcknCc) 

### 明日计划

- 925班车自动保存服务移入IOC

---

## 8月28日

| 工作事项                               | 进度         | 项目                       | 文档                                                         | 工作量 | 协作者 |
| -------------------------------------- | ------------ | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 引用bindData脏数据清理与复制脏数据排查 | ✅ 已完成     | Kunlun Builder, 元数据引用 |                                                              | M      |        |
| 复合组件的属性也会在输出面板中展示     | ✅ 已完成     | Kunlun Builder, 复合组件   | [fix: 修复复合组件输出值错误包含了输入值](https://code.byted.org/apaas/monorepo/commit/3398a118b8943460fada1749450dae5c70ba01fb) | S      |        |
| 权限参数对比逻辑更改                   | ✅ 已完成     | Kunlun Builder, 权限       | [chore: 权限参数对比逻辑更改](https://code.byted.org/apaas/monorepo/commit/1f0d13af3e56416698d37d442f69ac53f3a9bf27) | S      |        |
| API响应处理abort                       | 📈 连续到明天 | Kunlun Builder, API处理    |                                                              |        |        |
| 服务端版本锁合码                       | ✅ 已完成     | Kunlun Builder, 自动保存   | https://code.byted.org/apaas/monorepo/merge_requests/7877    | M      |        |
| 修复fx默认值无法引入uuid               | ✅ 已完成     | Kunlun Builder, 性能优化   | [fix: resolve default fx cannot import uuid](https://code.byted.org/apaas/monorepo/commit/fd5cbbea856571c59e589f485145ebc5656f999c?merge_request_iid=7939) | XS     |        |

### 笔记

- 复制bindData脏数据排查：bindData的数据源uidl复制后确实没有清掉原来的那份，这里复制粘贴操作可能会引起uidl指数级增大

![img](https://bytedance.larkoffice.com/space/api/box/stream/download/asynccode/?code=ODFlMDY0MGYxOTJiZmI2NmFkMzZhMzYwYTRjZDk2ZmJfZWU4WmJKSElFYm1SM2lINjI3ZlludDIxdEVocWdVQmlfVG9rZW46QjVPYWJxS1JIb3FoZVd4SVM2d2N6ZGlyblRjXzE3MDAxMzE3NjY6MTcwMDEzNTM2Nl9WNA)

- 单改多图表部分冲突检测方案汇总
  - v2图表对齐v1把后端所需的参数写入UIDL，收集后删除
  - 图表把UIDL转参数相关逻辑移入shared-pure-utils或者maker-service
  - BI后端直接依赖图表UIDL
  - （废弃⚠️）之前说的提供图表参数service，调研后发现是大坑，算不上是长期方案（见shared-service [关于事件动作品质保障的一些思考🤔](https://bytedance.feishu.cn/wiki/XQBywZAuViziimk0twBcLevfnhb) ）

### 明日计划

- 图表组件兼容失败情况
  - packages/builder/plugin-value-material/src/kunlun-builtin-provider/runtime/data-analytics/model.ts
- 依赖ID的接口梳理

---

## 8月27日（周末加班半天 🤨）

| 工作事项                         | 进度     | 项目                       | 文档                                                         | 工作量 | 协作者 |
| -------------------------------- | -------- | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 修复数据集单值取多值引用提取错误 | ✅ 已完成 | Kunlun Builder, 元数据引用 | [fix: 修复数据集单值取多值引用提取错误](https://code.byted.org/apaas/monorepo/commit/8e68720d3150c602b472961c8602988519a36bf3) | M      |        |

### 明日计划

- 服务端版本锁合码
- 830遗留缺陷清空

---

## 8月25日

| 工作事项                                    | 进度         | 项目                       | 文档                                                         | 工作量 | 协作者 |
| ------------------------------------------- | ------------ | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 排查图表请求失败返回空字符串原因            | ✅ 已完成     | Kunlun Builder, API处理    |                                                              | L      | 吴磊   |
| 修复请求abort时解析响应逻辑没有走到reject   | ✅ 已完成     | Kunlun Builder, API处理    | [fix: 修复请求abort时解析响应逻辑没有走到reject](https://code.byted.org/apaas/monorepo/commit/0e39530bd813b5e2e34e30720a703372178d0181) | S      |        |
| 页面被删除接口报错处理逻辑收口在API策略处理 | ✅ 已完成     | Kunlun Builder, API处理    | [feat: 页面被删除接口报错处理逻辑收口在API策略处理](https://code.byted.org/apaas/monorepo/commit/8a44292dec4f9beb834b2884f96b586027a8352a) | M      |        |
| 调试工具2.0复刻版交接文档                   | ✅ 已完成     | Kunlun Builder, 身份模拟   | [调试工具2.0复刻版交接文档](https://bytedance.feishu.cn/docx/Qzand2gpRoX85axtH0xcB9QxnNd) | M      |        |
| 引用bindData脏数据清理与复制脏数据排查      | 📈 连续到明天 | Kunlun Builder, 元数据引用 |                                                              |        |        |

### 笔记

- 排查图表请求失败返回空字符串原因：
  - *为什么指标卡和进度图偶尔展示0？*
  -  图表在响应为空字符串时展示0
  - *为什么图表响应会为空字符串？*
  -  Builder 底层网络请求的 aok 库，在请求被 abort 掉之后，没有走 reject 逻辑，而是返回了非预期的空字符串数据，导致指标卡和进度图展示了无数据的状态。
  - *为什么请求被abort不走reject逻辑？*
  -  http状态码为200，此时必走resolve逻辑
  - *为什么http状态码为200？*
  -  请求数据有两个异步过程
  - 异步阶段一：向后端请求数据，数据未返回
  - 异步阶段二：后端已返回数据，http状态码固化为200，此时需要执行`JSON.parse(response.body)`
  -  在阶段二执行abort，就会触发api响应处理的边界场景：响应数据为空（abort置空了）同时http状态码为200，因此图表组件层接受到了空字符串
  - *为什么在PC端和iOS移动端无法复现，仅安卓移动端能偶尔复现，部分安卓机型甚至频繁出现？*
  -  和性能有关，性能弱的机型执行`JSON.parse(response.body)`比较耗时，非常容易在异步二阶段触发abort。而性能好的机型在异步二阶段执行parse非常快，只会在一阶段触发触发abort。

```JavaScript
// 模拟代码
function start() {
  const obj = {
    abort: () => {},
  };
  async function request(obj) {
    const ac = new AbortController();
    obj.abort = () => {
      ac.abort();
    };
    const res = await fetch('https://cloudapi.bytedance.net/faas/services/ttvk99/invoke/testfetch', {
      signal: ac.signal,
    });
    try {
      // 随时触发abort
      setTimeout(() => {
        obj.abort();
      });
      const data = await res.json();
      console.log(1111, data);
    } catch (err) {
      console.log(1112, err);
      console.log(1113, res.status);
    }
  }
  request(obj);
}
start();
```

### 明日计划

- 修复容易引起oncall的p2问题

---

## 8月24日

| 工作事项                                         | 进度     | 项目                       | 文档                                                         | 工作量 | 协作者 |
| ------------------------------------------------ | -------- | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 编辑锁失效调试                                   | ✅ 已完成 | Kunlun Builder, 自动保存   | [chore: 编辑锁失效调试](https://code.byted.org/apaas/monorepo/commit/0a533ab09bb98e74ab3de97048cfca67d9349650) | XS     |        |
| 页面版本模型单测                                 | ✅ 已完成 | Kunlun Builder, 自动保存   | [test: 页面版本模型单测](https://code.byted.org/apaas/monorepo/commit/8d3c677a0ddd64c8cfbf6661fe43f59730de4662) | M      |        |
| 草稿更新接口冲突与删除时禁止出错误提示           | ✅ 已完成 | Kunlun Builder, 自动保存   | [feat: 草稿更新接口冲突与删除时禁止出错误提示](https://code.byted.org/apaas/monorepo/commit/6a9233f051c2df09a044fad15d961f2f08638da4) | S      |        |
| 保存处理增加错误处理插件机制并接入冲突与删除插件 | ✅ 已完成 | Kunlun Builder, 自动保存   | [feat: 保存处理增加错误处理插件机制并接入冲突与删除插件](https://code.byted.org/apaas/monorepo/commit/35a800c5600d02bfaef5b0da3e210e7a783217b5) | M      |        |
| 更新保存接口错误提示对话框文案                   | ✅ 已完成 | Kunlun Builder, 自动保存   | [chore: 更新保存接口错误提示对话框文案](https://code.byted.org/apaas/monorepo/commit/14589b97fb94095bc163a75aa06289d54e9ffc79) | S      |        |
| 领域模型图表参数收集插件                         | ✅ 已完成 | Kunlun Builder, 元数据引用 | [feat: 领域模型图表参数收集插件](https://code.byted.org/apaas/monorepo/commit/f4dc72837f168a6ccb54befa9b19bd12e8f32284) | S      |        |

### 笔记

- 冲突检测需求中Builder图表部分会有风险

### 明日计划

- 页面被删除接口报错处理逻辑收口在API策略处理

---

## 8月23日

| 工作事项                         | 进度     | 项目                     | 文档                                                         | 工作量 | 协作者 |
| -------------------------------- | -------- | ------------------------ | ------------------------------------------------------------ | ------ | ------ |
| api策略入参增加请求api名称       | ✅ 已完成 | Kunlun Builder, API处理  | [feat: api策略入参增加请求api名称](https://code.byted.org/apaas/monorepo/commit/83671082005332451a59488f4bb9022e5e6c5237) | M      |        |
| 页面草稿冲突弹窗与强制保存功能   | ✅ 已完成 | Kunlun Builder, 自动保存 | [feat: 页面草稿冲突弹窗与强制保存功能](https://code.byted.org/apaas/monorepo/commit/4cf183f683812abb093764ed624f7994d2dc3ec8) | M      |        |
| 测试工具交接后问题汇总           | ✅ 已完成 | Kunlun Builder, 身份模拟 | [测试工具交接后问题汇总](https://bytedance.feishu.cn/docx/ZHpjdr8yvo4UX8x7szbcioOvnZb) | M      |        |
| 去除身份模拟下无法切换页面的限制 | ✅ 已完成 | Kunlun Builder, 身份模拟 | [chore: 去除身份模拟下无法切换页面的限制](https://code.byted.org/apaas/monorepo/commit/17c62cd23aaf088f9c7217cc63a11e387dec0d3f) | S      | 成士豪 |

### 笔记

- [测试工具交接后问题汇总](https://bytedance.feishu.cn/docx/ZHpjdr8yvo4UX8x7szbcioOvnZb) 

### 明日计划

- 测试工具交接文档（周五）
- 草稿冲突单测
- 草稿冲突自测
- 领域模型图表参数收集插件

---

## 8月22日

| 工作事项                     | 进度     | 项目                     | 文档                                                         | 工作量 | 协作者 |
| ---------------------------- | -------- | ------------------------ | ------------------------------------------------------------ | ------ | ------ |
| 增加uuid与sha1纯函数         | ✅ 已完成 | Kunlun Builder, 自动保存 | [feat: 增加uuid与sha1纯函数](https://code.byted.org/apaas/monorepo/commit/56088390cc72a75d66a6fd938a51ded30e95ab81) | M      |        |
| 生命周期钩子增加保存请求前   | ✅ 已完成 | Kunlun Builder, 自动保存 | [feat(multiple): 生命周期钩子增加保存请求前](https://code.byted.org/apaas/monorepo/commit/89e821b9908f59092295cd5e7b91641a9bfbbff8) | S      |        |
| 增加页面保存完成生命周期钩子 | ✅ 已完成 | Kunlun Builder, 自动保存 | [feat: 增加页面保存完成生命周期钩子](https://code.byted.org/apaas/monorepo/commit/f83d5bc6829fc28db00da609f17188f92ad7a1ec) | S      |        |
| 页面版本生成工具             | ✅ 已完成 | Kunlun Builder, 自动保存 | [feat: 页面版本生成工具](https://code.byted.org/apaas/monorepo/commit/c9099c6846ad8bc4aed2c7444cc85f8fe2ec0b97) | M      |        |

### 笔记

- meta接口提供的subFieldPath信息需要增加类型
- 数据表格行按钮的 `/table/runtime/data` 流程鉴权接口无法处理没有绑定记录的直接运行流程，需要走需求修改

### 明日计划

- 页面草稿冲突弹窗与强制保存功能

---

## 8月21日

| 工作事项                            | 进度     | 项目                 | 文档                                                         | 工作量 | 协作者 |
| ----------------------------------- | -------- | -------------------- | ------------------------------------------------------------ | ------ | ------ |
| 述职文档关键产出部分                | ✅ 已完成 | Bytedance            | [刘洋兴 -2023 interview](https://bytedance.feishu.cn/docx/JmfNdeJP7obLD0xgaEucZ5QQnfg) | L      |        |
| 流程权限pre condition不传记录ID评估 | ✅ 已完成 | Kunlun Builder, 权限 |                                                              |        |        |

### 笔记

- 流程权限校验逻辑变动：入参记录值为空，默认有权限

### 明日计划

- 述职文档其他产出部分
- 服务端版本锁

---

## 8月18日

| 工作事项                                       | 进度     | 项目                     | 文档                                                         | 工作量 | 协作者 |
| ---------------------------------------------- | -------- | ------------------------ | ------------------------------------------------------------ | ------ | ------ |
| 时间机器计算字节，特征值、计算时间功能         | ✅ 已完成 | Kunlun Builder, 调试工具 | [feat: 时间机器计算字节，特征值、计算时间功能](https://code.byted.org/apaas/monorepo/commit/943eb9f3812945d1e980eb815dbb7a59cc24f870) | M      |        |
| maker status开放api聚合更改锁状态              | ✅ 已完成 | Kunlun Builder, 调试工具 | [feat: maker status开放api聚合更改锁状态](https://code.byted.org/apaas/monorepo/commit/2173912e7ee91311a06ad68e4161008867e27358) | S      |        |
| 工具箱视图模型                                 | ✅ 已完成 | Kunlun Builder, 调试工具 | [feat: 工具箱视图模型](https://code.byted.org/apaas/monorepo/commit/76f15330baa78d1c6854a88dde9bcdc1dcd6f356) | S      |        |
| 调试工具监听键盘事件打开视图                   | ✅ 已完成 | Kunlun Builder, 调试工具 | [feat: 调试工具监听键盘事件打开视图](https://code.byted.org/apaas/monorepo/commit/fafda60864a3e06909bbf2a0e55521446f26ee70) | S      |        |
| 工具箱导入导出db与屏幕录制工具                 | ✅ 已完成 | Kunlun Builder, 调试工具 | [feat: 工具箱导入导出db与屏幕录制工具](https://code.byted.org/apaas/monorepo/commit/617553214d98bff1b10cda1a2ec4b3eb2079eb2a) | S      |        |
| 工具箱视图层                                   | ✅ 已完成 | Kunlun Builder, 调试工具 | [feat: 工具箱视图层](https://code.byted.org/apaas/monorepo/commit/114f0475796577ecdbfa4f4cdce8a5303ebdf735) | M      |        |
| 新增编辑，录制，容量，历史记录工具             | ✅ 已完成 | Kunlun Builder, 调试工具 | [feat: 新增编辑，录制，容量，历史记录工具](https://code.byted.org/apaas/monorepo/commit/d7e507492e3956f2db9bdfb9d562b45d590becc9) | M      |        |
| 通用无数据状态视图                             | ✅ 已完成 | Kunlun Builder, 调试工具 | [feat: 通用无数据状态视图](https://code.byted.org/apaas/monorepo/commit/a4b9f7d64d476857248bc7548c17d6eb73ee92e3) | S      |        |
| 时间机器视图接入无数据组件                     | ✅ 已完成 | Kunlun Builder, 调试工具 | [chore: 时间机器视图接入无数据组件](https://code.byted.org/apaas/monorepo/commit/f1cdbc29e78ad2e9849edeab8ab8fbaec6bf086b) | XS     |        |
| 时间机器视图应用记录二次确认，最新记录不可删除 | ✅ 已完成 | Kunlun Builder, 调试工具 | [perf: 时间机器视图应用记录二次确认，最新记录不可删除](https://code.byted.org/apaas/monorepo/commit/a92eb7a810b88b723cb2caf11a5f0309f8dca645) | S      |        |
| 引用面板视图接入无数据状态                     | ✅ 已完成 | Kunlun Builder, 调试工具 | [chore: 引用面板视图接入无数据状态](https://code.byted.org/apaas/monorepo/commit/1e3240ecf07d93599a25e3dc7a8f369257248229) | XS     |        |
| 工具箱面板接入调试工具面板                     | ✅ 已完成 | Kunlun Builder, 调试工具 | [feat: 工具箱面板接入调试工具面板](https://code.byted.org/apaas/monorepo/commit/a77f477325b66f797fc6c0e0ce5bf2a9e596936b) | S      |        |
| 工具箱更新回放跳转地址                         | ✅ 已完成 | Kunlun Builder, 调试工具 | [chore: 工具箱更新回放跳转地址](https://code.byted.org/apaas/monorepo/commit/2b27c06f4a8d65189dd1f05f76fa8a21a582aa58) | XS     |        |
| 下线调试工具灰度                               | ✅ 已完成 | Kunlun Builder, 调试工具 | [chore: 下线调试工具灰度](https://code.byted.org/apaas/monorepo/commit/9bd94c5aa097e60c528cd4295dd6fa510bc0bbfe) | XS     |        |
| 不处于调试模式也可通过键盘打开面板             | ✅ 已完成 | Kunlun Builder, 调试工具 | [perf: 不处于调试模式也可通过键盘打开面板](https://code.byted.org/apaas/monorepo/commit/da19c0c3e94650d271371205c1bafdd6bc6d2b6c) | S      |        |
| 时间机器异步计算特征数据                       | ✅ 已完成 | Kunlun Builder, 调试工具 | [feat: 时间机器异步计算特征数据](https://code.byted.org/apaas/monorepo/commit/fb08c5ffdb7316eb85e78ec7318825dcba37d7a9) | M      |        |
| 时间机器面板接入触发特征计算与展示             | ✅ 已完成 | Kunlun Builder, 调试工具 | [feat: 时间机器面板接入触发特征计算与展示](https://code.byted.org/apaas/monorepo/commit/94de39d4806401fb245420da1801afb9fc0b127d) | M      |        |

### 明日计划

- 完成述职文档关键产出部分

---

## 8月17日

| 工作事项                                    | 进度     | 项目                       | 文档                                                         | 工作量 | 协作者 |
| ------------------------------------------- | -------- | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 重命名DomainSpecificSourceType为ApaasSource | ✅ 已完成 | Kunlun Builder, 元数据引用 | [refactor(@kunlun/shared-pure-utils): rename enum DomainSpecificSourceType to ApaasSource](https://code.byted.org/apaas/monorepo/commit/d48a5837cf39f515f628c5c3a6ec5b3fdca26a34) | S      |        |
| apaas source常量与类型声明                  | ✅ 已完成 | Kunlun Builder, 元数据引用 | [feat(@kunlun/shared-pure-utils): type and constant of apaas source](https://code.byted.org/apaas/monorepo/commit/d3af6c849cfbd101323b20d9cd9178f5bf87b120) | M      |        |
| apaas source meta和api id的校验             | ✅ 已完成 | Kunlun Builder, 元数据引用 | [feat(@kunlun/shared-pure-utils): apaas source validator for meta and api id](https://code.byted.org/apaas/monorepo/commit/aa10c32d4dbe8c3ee96275b6fd3181be7998e5f5) | M      |        |
| 单测 apaas source meta和api id的校验        | ✅ 已完成 | Kunlun Builder, 元数据引用 | [test(@kunlun/shared-pure-utils): apaas source validator for meta and api id](https://code.byted.org/apaas/monorepo/commit/3ee479b35deef5cf160b73c75f98d556c54d7a88) | M      |        |
| apaas source源序列化处理器                  | ✅ 已完成 | Kunlun Builder, 元数据引用 | [feat(@kunlun/shared-pure-utils): apaas source processor for source serialization](https://code.byted.org/apaas/monorepo/commit/965c6aa6b68a1fb0cb19c7fc0b367a1fc541d027) | M      |        |
| 单测 apaas source源序列化处理器             | ✅ 已完成 | Kunlun Builder, 元数据引用 | [test(@kunlun/shared-pure-utils): apaas source processor for source serialization](https://code.byted.org/apaas/monorepo/commit/0bee5dc2d3b5005f9a24f8a69cdf99baafb7d59e) | M      |        |
| apaas source实体与对外暴露api               | ✅ 已完成 | Kunlun Builder, 元数据引用 | [feat(@kunlun/shared-pure-utils): apaas source entity with practical api](https://code.byted.org/apaas/monorepo/commit/595655d5a66deee2dce3b3e1d1dc12691e79d1a9) | M      |        |
| 单测 apaas source实体与对外暴露api          | ✅ 已完成 | Kunlun Builder, 元数据引用 | [test(@kunlun/shared-pure-utils): apaas source entity with practical api](https://code.byted.org/apaas/monorepo/commit/b013bb464727494e85ff4ed6eea578088e22037a) | M      |        |

### 明日计划

- 调试工具新增工具箱编辑，录制，容量，历史记录工具

---

## 8月16日

| 工作事项                                           | 进度     | 项目                     | 文档                                                         | 工作量 | 协作者 |
| -------------------------------------------------- | -------- | ------------------------ | ------------------------------------------------------------ | ------ | ------ |
| 历史记录复制、搜索、删除二次确认、收藏禁止删除功能 | ✅ 已完成 | Kunlun Builder, 调试工具 | [feat(@kunlun/app-maker): 历史记录复制、搜索、删除二次确认、收藏禁止删除功能](https://code.byted.org/apaas/monorepo/commit/f313e44cc5ec3dd5fa4ef7e0f8a6ec36e48c5129) | M      |        |
| 流程权限校验precondition结论                       | ✅ 已完成 | Kunlun Builder, 权限     |                                                              |        |        |

### 笔记

- 流程权限校验precondition结论：前提不成立，无法继续评估
  - 新建表单场景，按钮绑流程，加不加 pre condition 都会置灰，通不过

### 明日计划

- apaas source 引用标记工具

---

## 8月15日

| 工作事项                         | 进度         | 项目                       | 文档 | 工作量 | 协作者 |
| -------------------------------- | ------------ | -------------------------- | ---- | ------ | ------ |
| 对齐 WebRuntime 排期风险         | ✅ 已完成     | Kunlun Builder, 全局       |      | M      |        |
| 记录收集没有触发                 | ✅ 已完成     | Kunlun Builder, 元数据引用 |      | S      | 吴磊   |
| 身份模拟后_search接口越权        | ✅ 已完成     | Kunlun Builder, 权限       |      | S      |        |
| resolveComponent函数耗时增加排查 | ✅ 已完成     | Kunlun Builder, 子页面拆分 |      | M      | 蔡南坤 |
| 流程权限校验precondition结论     | 📈 连续到明天 | Kunlun Builder, 权限       |      | S      |        |

### 笔记

- 对齐 WebRuntime 排期风险
  -  结论：WebRuntime单应用版本无需@刘洋兴 
- 身份模拟后 _search 接口越权，两个因素同时存在导致
  - Condition发 _search 请求没有带 X-Kunlun-PermitTestUser 请求头
  - 网关没有给 Builder 2.0 新版 URL 加白名单
- resolveComponent函数耗时增加
  -  原因：packages/builder/plugin-value-material/src/kunlun-builtin-provider/runtime/filter/conditions-resolver.ts文件存在 `O(2*n*n)` 的算法，非常非常慢

### 明日计划

- 历史记录复制、搜索、删除二次确认、收藏禁止删除功能

---

## 8月14日（发烧🌡️）

### 笔记

- Ref逻辑收口到Setter与数据源内 @黄鹏 @姚嘉松 

### 明日计划

- 对齐 WebRuntime 排期风险

---

## 8月13日（周末加班半天 🤨）

| 工作事项                            | 进度     | 项目                       | 文档                                                         | 工作量 | 协作者 |
| ----------------------------------- | -------- | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 多值取单值子对象Ref提取函数         | ✅ 已完成 | Kunlun Builder, 元数据引用 | [feat(@kunlun/shared-pure-utils): 多值取单值子对象Ref提取函数](https://code.byted.org/apaas/monorepo/commit/fa4db5c16a9aadd82f2187b013cd5b9415d7a99f) | M      |        |
| v2组件接入多值取单值子对象字段Ref   | ✅ 已完成 | Kunlun Builder, 元数据引用 | [feat: v2组件接入多值取单值子对象字段Ref](https://code.byted.org/apaas/monorepo/commit/ce4289cb8daba22202389b51f9355468008add22) | M      |        |
| 适配直接选子对象场景下无法过Ref校验 | ✅ 已完成 | Kunlun Builder, 元数据引用 | [fix(@kunlun/shared-pure-utils): 适配直接选子对象场景下无法过Ref校验](https://code.byted.org/apaas/monorepo/commit/7066657c729b766f9662e9866379d4dde1ed3c7a) | S      |        |
| 复合组件表单防止空值出现两个提示语  | ✅ 已完成 | Kunlun Builder, 复合组件   | [fix: 复合组件表单防止空值出现两个提示语](https://code.byted.org/apaas/monorepo/commit/f029a08a6f60792248d1b4880c302a537eb97dc8) | S      |        |

### 笔记

- TODO
  - 预览本地取数据（考虑锁状态）
  - 述职文档 V1（下周完成）
  - 房补申请

### 明日计划

- Web Runtime

---

## 8月11日

| 工作事项                       | 进度     | 项目                     | 文档                                                         | 工作量 | 协作者 |
| ------------------------------ | -------- | ------------------------ | ------------------------------------------------------------ | ------ | ------ |
| 生命周期钩子增加保存请求前     | ✅ 已完成 | Kunlun Builder, 性能优化 | [feat(multiple): 生命周期钩子增加保存请求前](https://code.byted.org/apaas/monorepo/commit/509efd378ca063b5a20c54a58e9a03724f27e4cf) | S      |        |
| 生命周期插件接入fx编译参数拼接 | ✅ 已完成 | Kunlun Builder, 性能优化 | [feat(multiple): 生命周期插件接入fx编译参数拼接](https://code.byted.org/apaas/monorepo/commit/d9f2f66830bba86d55a5fd86f6d7559c62691b14) | M      |        |
| 在设计器实例化fx client        | ✅ 已完成 | Kunlun Builder, 性能优化 | [feat(@kunlun/plugin-value-material): 在设计器实例化fx client](https://code.byted.org/apaas/monorepo/commit/ec4d822c226be2f4d1d77b14fee5d8d822ca6553) | S      |        |
| fxID生成函数与默认值判断函数   | ✅ 已完成 | Kunlun Builder, 性能优化 | [feat(@kunlun/shared-utils): fxID生成函数与默认值判断函数](https://code.byted.org/apaas/monorepo/commit/8fb51a77719fbfa100de09a9b704912fd84c2f32) | M      |        |
| 接入fxID到设计器               | ✅ 已完成 | Kunlun Builder, 性能优化 | [feat(multiple): 接入fxID到设计器](https://code.byted.org/apaas/monorepo/commit/218327726b8910e72ee466e7bcec0635d0a1f883) | S      |        |
| 领域模型收集fxID并校验是否重复 | ✅ 已完成 | Kunlun Builder, 性能优化 | [feat(@kunlun/shared-pure-utils): 领域模型收集fxID并校验是否重复](https://code.byted.org/apaas/monorepo/commit/ac3a3a63ce88b316a70a9974236d1a875f202594) | M      |        |
| uidl预处理给fx结构增加兜底fxid | ✅ 已完成 | Kunlun Builder, 性能优化 | [feat(@kunlun/shared-utils): uidl预处理给fx结构增加兜底fxid](https://code.byted.org/apaas/monorepo/commit/123b8af630856e623a167581440cfcb0959b9fb1) | M      |        |
| 保存流程适配fxclient api       | ✅ 已完成 | Kunlun Builder, 性能优化 | [feat(multiple): 保存流程适配fxclient api](https://code.byted.org/apaas/monorepo/commit/c7ca8e89c8a13a010cf11b67f72d7ffa62cca018) | M      |        |
| 运行时基座接入触发fx编译       | ✅ 已完成 | Kunlun Builder, 性能优化 | [chore: 运行时基座接入触发fx编译](https://code.byted.org/apaas/monorepo/commit/1a1fe15f45f380d6730695a5d292b4b5571bb1ec) | M      |        |

### 笔记

- 还有两个P2的BUG需要周末抽时间修复

### 明日计划

- 子对象字段Ref未提取
- 复合组件必填提示重复

---

## 8月10日

| 工作事项                             | 进度         | 项目                       | 文档                                                         | 工作量 | 协作者 |
| ------------------------------------ | ------------ | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 前置领域模型导出到traverse之前       | ✅ 已完成     | Kunlun Builder, 元数据引用 | [chore: 前置领域模型导出到traverse之前](https://code.byted.org/apaas/monorepo/commit/ffbd28f16d24281ffab3bd88cba56028733f3a24?merge_request_iid=6507) | S      |        |
| 给ApiIdMapping增加单测               | ✅ 已完成     | Kunlun Builder, 全局       | [test(@kunlun/shared-pure-utils): 给ApiIdMapping增加单测](https://code.byted.org/apaas/monorepo/commit/3d29d34c739c9a0ec11fa1b9e6c3cac6ad670103?merge_request_iid=6507) | M      |        |
| 页面卸载前去除自动保存对编辑锁的监听 | ✅ 已完成     | Kunlun Builder, 自动保存   | [chore: 页面卸载前去除自动保存对编辑锁的监听](https://code.byted.org/apaas/monorepo/commit/efdfe6954a5ca7b258e56ddb739d656aea15bca7?merge_request_iid=6507) | XS     |        |
| 述职文档草稿                         | 📈 连续到明天 | Bytedance                  |                                                              |        |        |

### 笔记

- 和@王智力 对了下，封板提前风险很大，需要抽时间提前完成fx预编译保存链路
- indexedDB导入导出代码

导出

```TypeScript
const dbName = 'PageTimeMachineDB';
const request = indexedDB.open(dbName);
request.onsuccess = function(event) {
  const db = event.target.result;
  const objectStoreNames = db.objectStoreNames;
  const data = {};
  let count = objectStoreNames.length;
  [...objectStoreNames].forEach(function(objectStoreName) {
    const transaction = db.transaction([objectStoreName], 'readonly');
    const objectStore = transaction.objectStore(objectStoreName);
    const request = objectStore.getAll();
    request.onsuccess = function(event) {
      data[objectStoreName] = event.target.result;
      count--;
      if (count === 0) {
        const blob = new Blob([JSON.stringify(data)], {type: 'application/json'});
        const url = URL.createObjectURL(blob);
        const a = document.createElement('a');
        a.href = url;
        a.download = `${dbName}.json`;
        a.click();
        db.close();
      }
    };
  });
};
```

导入

```TypeScript
const dbName = 'PageTimeMachineDB';
const request = indexedDB.open(dbName);

request.onsuccess = function(event) {
  const db = event.target.result;
  const fileInput = document.createElement('input');
  fileInput.type = 'file';

  fileInput.addEventListener('change', function(event) {
    const file = event.target.files[0];
    const reader = new FileReader();

    reader.addEventListener('load', function(event) {
      const data = JSON.parse(event.target.result);

      let count = Object.keys(data).length;

      for (const objectStoreName in data) {
        const transaction = db.transaction([objectStoreName], 'readwrite');
        const objectStore = transaction.objectStore(objectStoreName);
        const clearRequest = objectStore.clear();

        clearRequest.onsuccess = function() {
          const values = data[objectStoreName];
          const addRequests = [];

          for (const value of values) {
            const addRequest = objectStore.add(value);
            addRequests.push(addRequest);
          }

          Promise.all(addRequests).then(function() {
            count--;

            if (count === 0) {
              db.close();
              console.log('数据已成功写回 IndexedDB。');
            }
          });
        };
      }
    });

    reader.readAsText(file);
  });

  fileInput.click();
};
```

### 明日计划

- fx预编译保存链路

---

## 8月9日

| 工作事项                           | 进度         | 项目                    | 文档                                                         | 工作量 | 协作者 |
| ---------------------------------- | ------------ | ----------------------- | ------------------------------------------------------------ | ------ | ------ |
| 跳转无权限页参数对齐fe             | ✅ 已完成     | Kunlun Builder, API处理 | [chore: 更新无权限页跳转路径](https://code.byted.org/apaas/monorepo/commit/cd71b24fa1e55df98f7632a69e0e6a3f1f3570c6) |        |        |
| 去除无权限拼接from去除basename逻辑 | ✅ 已完成     | Kunlun Builder, API处理 | [chore: 去除无权限拼接from去除basename逻辑](https://code.byted.org/apaas/monorepo/commit/ac82800820267cbc915cadff936f6a003b03b5dc) |        |        |
| 述职文档草稿                       | 📈 连续到明天 | Bytedance               |                                                              |        |        |
| 学习@李有为 述职文档               | 📈 连续到明天 | Bytedance               | [2022 述职 李有为UIDL 拆分](https://bytedance.feishu.cn/docx/doxcnf106JJ5dpnBT3zvLQTIZfg) |        | 李有为 |
| 学习@唐词伟 述职文档               | 📈 连续到明天 | Bytedance               | [答辩文档-唐词伟 副本](https://bytedance.feishu.cn/docx/A5CWdrsDDoLV0Mx4i6ncN4pxngg) |        | 唐词伟 |
| 学习@徐人杰 述职文档               | 📈 连续到明天 | Bytedance               | [徐人杰-2021.02 interview](https://bytedance.feishu.cn/docs/doccnEK5kiyCppltYgskzGJvJ6c) |        |        |

### 笔记

- 9.14班车封板时间提前到8.30，三个9.14需求存在风险
  - fx预编译
  - Web runtime二期
  - 服务端编辑锁

### 明日计划

- 封板提前风险对齐
- 给ApiIdMapping增加单测

---

## 8月8日

| 工作事项                           | 进度       | 项目                       | 文档                                                         | 工作量 | 协作者 |
| ---------------------------------- | ---------- | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| 回滚fx预编译保存链路代码           | ✅ 已完成   | Kunlun Builder, 性能优化   | [revert: 回滚fx预编译保存链路代码](https://code.byted.org/apaas/monorepo/commit/a3d6f8b330960686fef8c91d453c1401f2d87f52?merge_request_iid=6683) | M      |        |
| 删除fx预编译灰度逻辑               | ✅ 已完成   | Kunlun Builder, 性能优化   | [chore: 删除fx预编译灰度逻辑](https://code.byted.org/apaas/monorepo/commit/639216acbe18a6570c7af4f141d4302b280316f4?merge_request_iid=6683) | S      |        |
| 运行时去除从uidl读取fxid的逻辑     | ✅ 已完成   | Kunlun Builder, 性能优化   | [chore: 运行时去除从uidl读取fxid的逻辑](https://code.byted.org/apaas/monorepo/commit/fa940c63bb311994fafd3de5cea48626015a80e0?merge_request_iid=6683) | XS     |        |
| DomainModel中condition的$$结构去除 | ⏱ 推迟一天 | Kunlun Builder, 元数据引用 |                                                              |        |        |
| 跳转无权限页参数对齐fe             | ⏱ 推迟一天 | Kunlun Builder, API处理    |                                                              |        |        |
| 多角色权限合并问题排查             | ✅ 已完成   | Kunlun Builder, 权限       |                                                              | S      |        |
| fxID生成重复问题排查               | ✅ 已完成   | Kunlun Builder, 性能优化   |                                                              | S      |        |
| 复合组件设计态问题整理             | ✅ 已完成   | Kunlun Builder, 复合组件   | [复合组件整理](https://bytedance.feishu.cn/docx/KCDMd37T8oCuIXx8mWScTH6sn5b) | M      |        |

### 笔记

- [复合组件整理](https://bytedance.feishu.cn/docx/KCDMd37T8oCuIXx8mWScTH6sn5b) 

### 明日计划

- 述职文档草稿（必须完成）

---

## 8月7日

| 工作事项                           | 进度         | 项目                       | 文档 | 工作量 | 协作者 |
| ---------------------------------- | ------------ | -------------------------- | ---- | ------ | ------ |
| DomainModel中condition的$$结构去除 | ⏱ 推迟一天   | Kunlun Builder, 元数据引用 |      |        |        |
| 多角色权限合并问题排查             | ⏱ 推迟一天   | Kunlun Builder, 权限       |      |        |        |
| 删除校验不生效问题排查             | ✅ 已完成     | Kunlun Builder, 元数据引用 |      |        |        |
| 操作日志越权问题排查               | ✅ 已完成     | Kunlun Builder, 权限       |      |        |        |
| 数据表格无数据权限问题排查         | ✅ 已完成     | Kunlun Builder, 权限       |      |        |        |
| 数据表格行按钮直接运行流程无权限   | ✅ 已完成     | Kunlun Builder, 权限       |      |        |        |
| fxID生成重复问题排查               | ⏱ 推迟一天   | Kunlun Builder, 性能优化   |      |        |        |
| 班车BUG清理                        | 📈 连续到明天 | Kunlun Builder, 全局       |      |        |        |

### 笔记

- 又有两例反馈丢数据，服务端校验优先级上升
- 班车问题排查

| 删除校验不生效                   | refCheck接口错误                     | @李全刚 |
| -------------------------------- | ------------------------------------ | ------- |
| 操作日志越权                     | action_log接口越权                   | @郑文轩 |
| 数据表格无数据权限               | QA没配置记录权限                     | @张佳松 |
| 数据表格行按钮直接运行流程无权限 | 事件未屏蔽数据表格行按钮直接运行流程 | @王雨森 |
| fxID生成重复问题排查             | meta是常量造成重复                   | @刘洋兴 |

### 明日计划

- 跳转无权限页参数对齐fe
- 述职文档草稿
- 回滚fx预编译保存链路代码

---

## 8月4日

| 工作事项                           | 进度       | 项目                       | 文档                                                         | 工作量 | 协作者 |
| ---------------------------------- | ---------- | -------------------------- | ------------------------------------------------------------ | ------ | ------ |
| fx预编译问题对齐                   | ✅ 已完成   | Kunlun Builder, 性能优化   |                                                              | M      |        |
| fx预编译方案对比文档               | ✅ 已完成   | Kunlun Builder, 性能优化   | [fx预编译方案对比](https://bytedance.feishu.cn/docx/QOUGdS21bom6aGxgl6YcCJ27nKe) | M      |        |
| fx预编译方案确认                   | ✅ 已完成   | Kunlun Builder, 性能优化   |                                                              | L      |        |
| DomainModel中condition的$$结构去除 | ⏱ 推迟一天 | Kunlun Builder, 元数据引用 |                                                              |        |        |
| rspack问题排查                     | ✅ 已完成   | Kunlun Builder, 全局       |                                                              | M      |        |
| 手上的事优先级对齐                 | ✅ 已完成   | Bytedance                  | [手上的事（优先级）](https://bytedance.feishu.cn/docx/Obuud0M2Ao6TEHxqYVVc4vlTnaf) | S      |        |

### 笔记

- [fx预编译方案对比](https://bytedance.feishu.cn/docx/QOUGdS21bom6aGxgl6YcCJ27nKe) 
- fx性能优化遇到大风险：uidl编译遇到卡点，编译入参大小限制为64kb

### 明日计划

- 述职文档草稿

---

## 8月3日

| 工作事项                           | 进度       | 项目                       | 文档 | 工作量 | 协作者      |
| ---------------------------------- | ---------- | -------------------------- | ---- | ------ | ----------- |
| 线上缺陷清理（批量选择权限）       | ✅ 已完成   | Kunlun Builder, 权限       |      | S      |             |
| 编辑锁状态隐藏保存组件             | ✅ 已完成   | Kunlun Builder, 自动保存   |      |        |             |
| db清除逻辑与报错优化               | ✅ 已完成   | Kunlun Builder, 调试工具   |      |        |             |
| 移动端loading图片宽度不正常        | ✅ 已完成   | Kunlun Builder, 性能优化   |      |        |             |
| 页面权限裁剪逻辑梳理               | ⏱ 推迟一天 | Kunlun Builder, 权限       |      |        |             |
| DomainModel中condition的$$结构去除 | ⏱ 推迟一天 | Kunlun Builder, 元数据引用 |      |        |             |
| 述职文档草稿                       | ⏱ 推迟一天 | Bytedance                  |      |        | 陈辰,王智力 |
| 和@孟轩竹 查找丢数据原因           | ⏱ 推迟一天 | Kunlun Builder, 自动保存   |      |        |             |

### 笔记

- fx预编译今天暴露了两个大问题
  - uidl编译入参限制30个fx
  - fx编译的 cdn 会失效

### 明日计划

- fx预编译问题对齐
- fx预编译方案对比文档
- fx预编译方案确认
- DomainModel中condition的$$结构去除

---

## 8月2日

| 工作事项                        | 进度         | 项目                       | 文档                                                         | 工作量 | 协作者      |
| ------------------------------- | ------------ | -------------------------- | ------------------------------------------------------------ | ------ | ----------- |
| 述职文档草稿                    | ⏱ 推迟一天   | Bytedance                  |                                                              |        | 陈辰,王智力 |
| 学习@李有为 述职文档            | 📈 连续到明天 | Bytedance                  | [2022 述职 李有为](https://bytedance.feishu.cn/docx/doxcnf106JJ5dpnBT3zvLQTIZfg) |        | 李有为      |
| 服务端UIDL拆分方案Review        | ✅ 已完成     | Kunlun Builder, 子页面拆分 | [【技术方案】UIDL 拆分](https://bytedance.feishu.cn/docx/F6eudQjyGo5G2pxVGsxcZ0pEnyh) | M      | 唐强        |
| 学习@唐词伟 述职文档            | 📈 连续到明天 | Bytedance                  | [答辩文档-唐词伟 副本](https://bytedance.feishu.cn/docx/A5CWdrsDDoLV0Mx4i6ncN4pxngg) |        | 唐词伟      |
| 复合组件P0无限循环问题排查      | ✅ 已完成     | Kunlun Builder, 复合组件   |                                                              | M      | 姚嘉松      |
| 自定义组件js setVar后按钮无权限 | ✅ 已完成     | Kunlun Builder, 权限       |                                                              | M      | 杨朔,林恭瑜 |

### 笔记

- 复合组件循环问题是表单引擎对 `Map` 的不当操作引起的

无限循环

```TypeScript
const map = new Map();
map.set('a', 1);
map.forEach((item) => {
  console.log(item);
  map.delete('a', 2);
  map.set('a', 2);
});
```

不循环

```TypeScript
const map = new Map();
map.set('a', 1);
Array.from(map.values()).forEach((item) => {
  console.log(item);
  map.delete('a', 2);
  map.set('a', 2);
});
```

- 自定义组件js setVar后按钮无权限原因：传入的 `Record._id` 类型是 `string` 导致校验无法通过

### 明日计划

- 移动端loading图片宽度不正常
- 编辑锁状态隐藏保存组件
- 运行时依赖全量UIDL去除
  - 运行时多实例
  - 页面权限裁切
- 线上缺陷清理
- db清除逻辑与报错优化

---

## 8月1日（病假🤒）

| 工作事项    | 进度     | 项目                       | 文档 | 工作量 | 协作者 |
| ----------- | -------- | -------------------------- | ---- | ------ | ------ |
| Ref全量上线 | ✅ 已完成 | Kunlun Builder, 元数据引用 |      | S      |        |

### 明日计划

- 述职文档